/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.book.install.BookIcon;
import org.crosswire.jsword.book.Book;

public class BookListCellRenderer
extends DefaultListCellRenderer {
    private boolean abbreviated;
    public static final String PROTOTYPE_BOOK_NAME = "0123456789";
    private static final long serialVersionUID = 3978138859576308017L;

    public BookListCellRenderer() {
        this(false);
    }

    public BookListCellRenderer(boolean abbreviated) {
        this.abbreviated = abbreviated;
    }

    public boolean isAbbreviated() {
        return this.abbreviated;
    }

    public void setAbbreviated(boolean newAbbreviated) {
        this.abbreviated = newAbbreviated;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, selected, focus);
        this.setToolTipText(null);
        if (value == null) {
            this.setText(Msg.NONE.toString());
            this.setEnabled(false);
        }
        if (value instanceof Book) {
            Book book = (Book)value;
            String name = book.getName();
            this.setText(this.abbreviated ? book.getInitials() : name);
            this.setToolTipText(name);
            this.setIcon(BookIcon.getIcon(book));
        }
        return comp;
    }
}

