/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.Msg;
import org.crosswire.common.swing.StackTraceListModel;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.ReporterEvent;
import org.crosswire.common.util.ReporterListener;
import org.crosswire.common.util.StackTrace;
import org.crosswire.common.xml.XMLUtil;

public final class ExceptionPane
extends JPanel {
    private Throwable ex;
    private JList list;
    private JPanel upper;
    private JLabel label;
    private JTextArea text;
    private JButton ok;
    private JCheckBox detail;
    private JPanel lower;
    private static File[] sources;
    private static ExceptionPaneReporterListener li;
    private static final long serialVersionUID = 3258126947203495219L;

    private ExceptionPane(Throwable ex) {
        this.ex = ex;
        this.initialise();
        this.setDisplayedException(ex);
    }

    private void initialise() {
        MessageFormat msgFormat = new MessageFormat("<html><font size=\"-1\">{0}</font> {1}");
        String exmsg = msgFormat.format(new Object[]{Msg.ERROR_OCCURED.toString(), ExceptionPane.getHTMLDescription(this.ex)});
        JLabel message = new JLabel();
        message.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        message.setText(exmsg);
        message.setIcon(GuiUtil.getIcon("toolbarButtonGraphics/general/Stop24.gif"));
        message.setIconTextGap(20);
        JPanel banner = new JPanel(new BorderLayout());
        banner.add((Component)message, "Center");
        this.list = new JList();
        this.list.setVisibleRowCount(6);
        this.list.setSelectionMode(0);
        Font courier = new Font("Monospaced", 0, 12);
        this.list.setFont(courier);
        this.ok = new JButton();
        this.ok.setText(Msg.OK.toString());
        this.ok.setMnemonic(Msg.OK.toString().charAt(0));
        this.detail = new JCheckBox();
        this.detail.addItemListener(new SelectedItemListener(this));
        this.detail.setText(Msg.DETAILS.toString());
        JPanel spacer = new JPanel(new FlowLayout());
        spacer.add(this.ok);
        JPanel buttons = new JPanel(new BorderLayout());
        buttons.add((Component)spacer, "Center");
        buttons.add((Component)this.detail, "Before");
        this.upper = new JPanel(new BorderLayout());
        this.upper.add((Component)banner, "North");
        this.upper.add((Component)buttons, "Center");
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.label.setFont(courier);
        this.label.setText(Msg.NO_FILE.toString());
        this.text = new JTextArea();
        this.text.setEditable(false);
        this.text.setFont(courier);
        CWScrollPane textScroll = new CWScrollPane(this.text);
        textScroll.setColumnHeaderView(this.label);
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        for (Throwable throwable = this.ex; throwable != null; throwable = throwable.getCause()) {
            causes.add(throwable);
        }
        Throwable[] exs = causes.toArray(new Throwable[causes.size()]);
        JComboBox<Throwable> traces = new JComboBox<Throwable>();
        traces.setModel(new DefaultComboBoxModel<Throwable>(exs));
        traces.addActionListener(new SelectActionListener(this, traces));
        JPanel heading = new JPanel(new BorderLayout());
        heading.add(traces, "Center");
        FixedSplitPane split = new FixedSplitPane();
        split.setResizeWeight(0.2);
        split.setOrientation(0);
        split.setContinuousLayout(true);
        ((JSplitPane)split).setTopComponent(new CWScrollPane(this.list));
        ((JSplitPane)split).setBottomComponent(textScroll);
        split.setBorder(BorderFactory.createEmptyBorder());
        split.setPreferredSize(new Dimension(500, 300));
        this.lower = new JPanel(new BorderLayout());
        this.lower.add((Component)split, "Center");
        this.lower.add((Component)heading, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)this.upper, "North");
    }

    protected void changeDetail() {
        if (this.detail.isSelected()) {
            this.add((Component)this.lower, "Center");
        } else {
            this.remove(this.lower);
        }
        GuiUtil.getDialog(this).pack();
    }

    protected void setDisplayedException(Throwable ex) {
        StackTrace st = new StackTrace(ex);
        this.list.addListSelectionListener(new CustomLister(st, this.text, this.label));
        this.list.setModel(new StackTraceListModel(st));
    }

    public static void showExceptionDialog(Component parent, Throwable ex) {
        ExceptionPane pane = new ExceptionPane(ex);
        final JDialog dialog = new JDialog(GuiUtil.getFrame(parent));
        dialog.getRootPane().setDefaultButton(pane.ok);
        dialog.getRootPane().setLayout(new BorderLayout());
        dialog.getRootPane().setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, pane.upper.getBackground()));
        dialog.getRootPane().add((Component)pane, "Center");
        dialog.setTitle(Msg.ERROR.toString());
        pane.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                dialog.dispose();
            }
        });
        dialog.setModal(true);
        GuiUtil.centerWindow(dialog);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static void setSourcePath(File[] sourcePath) {
        sources = (File[])sourcePath.clone();
    }

    public static File[] getSourcePath() {
        return (File[])sources.clone();
    }

    public static void setHelpDeskListener(boolean joined) {
        if (joined && li == null) {
            li = new ExceptionPaneReporterListener();
            Reporter.addReporterListener((ReporterListener)li);
        }
        if (!joined && li != null) {
            Reporter.removeReporterListener((ReporterListener)li);
            li = null;
        }
    }

    public static boolean isHelpDeskListener() {
        return li != null;
    }

    public static String getHTMLDescription(Throwable ex) {
        StringBuffer retcode = new StringBuffer();
        String msg = ex.getMessage();
        if (msg == null || msg.equals("")) {
            msg = Msg.NO_DESC.toString();
        }
        String orig = XMLUtil.escape((String)msg);
        msg = orig.replaceAll("\n", "<br>");
        retcode.append("<br>");
        retcode.append(msg);
        Throwable nex = ex.getCause();
        if (nex != null) {
            retcode.append("<p><br><font size=\"-1\">");
            retcode.append((Object)Msg.CAUSED_BY);
            retcode.append("</font>");
            retcode.append(ExceptionPane.getHTMLDescription(nex));
        }
        return retcode.toString();
    }

    static {
        ExceptionPane.setHelpDeskListener(true);
        sources = new File[0];
    }

    private static final class MessageRunner
    implements Runnable {
        private ReporterEvent event;

        public MessageRunner(ReporterEvent ev) {
            this.event = ev;
        }

        public void run() {
            if (this.event.getSource() instanceof Component) {
                JOptionPane.showMessageDialog((Component)this.event.getSource(), this.event.getMessage());
            } else {
                JOptionPane.showMessageDialog(null, this.event.getMessage());
            }
        }
    }

    private static final class ExceptionRunner
    implements Runnable {
        private ReporterEvent event;

        public ExceptionRunner(ReporterEvent ev) {
            this.event = ev;
        }

        public void run() {
            if (this.event.getSource() instanceof Component) {
                ExceptionPane.showExceptionDialog((Component)this.event.getSource(), this.event.getException());
            } else {
                ExceptionPane.showExceptionDialog(null, this.event.getException());
            }
        }
    }

    static final class ExceptionPaneReporterListener
    implements ReporterListener {
        ExceptionPaneReporterListener() {
        }

        public void reportException(ReporterEvent ev) {
            SwingUtilities.invokeLater(new ExceptionRunner(ev));
        }

        public void reportMessage(ReporterEvent ev) {
            SwingUtilities.invokeLater(new MessageRunner(ev));
        }
    }

    private static final class CustomLister
    implements ListSelectionListener {
        private StackTrace st;
        private JTextArea mytext;
        private JLabel mylabel;

        public CustomLister(StackTrace st, JTextArea text, JLabel label) {
            this.st = st;
            this.mytext = text;
            this.mylabel = label;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent ev) {
            if (ev.getValueIsAdjusting()) {
                return;
            }
            SwingUtilities.getRoot(this.mylabel).setCursor(Cursor.getPredefinedCursor(3));
            JList lst = (JList)ev.getSource();
            int level = lst.getSelectedIndex();
            String name = this.st.getClassName(level);
            if (name.indexOf(36) != -1) {
                name = name.substring(0, name.indexOf(36));
            }
            int line_num = this.st.getLineNumber(level);
            String orig = name;
            Integer errorLine = new Integer(line_num);
            this.mylabel.setText(Msg.NO_FILE.toString());
            name = File.separator + orig.replace('.', File.separatorChar) + ".java";
            File[] srcs = ExceptionPane.getSourcePath();
            for (int i = 0; i < srcs.length; ++i) {
                File file = new File(srcs[i], name);
                if (!file.isFile() || !file.canRead()) continue;
                StringBuffer data = new StringBuffer();
                int selection_start = 0;
                int selection_end = 0;
                BufferedReader in = null;
                try {
                    String line;
                    String found = Msg.SOURCE_FOUND.toString(new Object[]{errorLine, file.getCanonicalPath()});
                    this.mylabel.setText(found);
                    in = new LineNumberReader(new FileReader(file));
                    while ((line = ((LineNumberReader)in).readLine()) != null) {
                        data.append(line).append('\n');
                        int current_line = ((LineNumberReader)in).getLineNumber();
                        if (current_line == line_num - 1) {
                            selection_start = data.length();
                        }
                        if (current_line != line_num) continue;
                        selection_end = data.length() - 1;
                    }
                }
                catch (IOException ex) {
                    data.append(ex.getMessage());
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            data.append(e.getMessage());
                        }
                    }
                }
                this.mytext.setText(data.toString());
                this.mytext.setSelectionStart(selection_start);
                this.mytext.setSelectionEnd(selection_end);
                SwingUtilities.getRoot(this.mylabel).setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            StringBuffer error = new StringBuffer(Msg.SOURCE_NOT_FOUND.toString(new Object[]{this.st.getClassName(level), errorLine}));
            for (int i = 0; i < srcs.length; ++i) {
                error.append(Msg.SOURCE_ATTEMPT.toString(new Object[]{srcs[i].getAbsolutePath() + name}));
            }
            this.mytext.setText(error.toString());
            SwingUtilities.getRoot(this.mylabel).setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private static final class SelectActionListener
    implements ActionListener {
        private ExceptionPane pane;
        private JComboBox traces;

        public SelectActionListener(ExceptionPane ep, JComboBox cb) {
            this.pane = ep;
            this.traces = cb;
        }

        public void actionPerformed(ActionEvent ev) {
            Throwable th = (Throwable)this.traces.getSelectedItem();
            this.pane.setDisplayedException(th);
        }
    }

    private static final class SelectedItemListener
    implements ItemListener {
        private ExceptionPane pane;

        public SelectedItemListener(ExceptionPane ep) {
            this.pane = ep;
        }

        public void itemStateChanged(ItemEvent ev) {
            this.pane.changeDetail();
        }
    }
}

