/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.crosswire.common.diff.Diff;
import org.crosswire.common.diff.DiffCleanup;
import org.crosswire.common.diff.Difference;
import org.crosswire.common.diff.EditType;
import org.crosswire.common.diff.Match;
import org.crosswire.common.diff.PatchEntry;

public class Patch {
    private static Pattern patchBoundaryPattern = Pattern.compile("\n@@");
    private List patches = new ArrayList();
    private int margin = PatchEntry.getMargin();

    public Patch() {
    }

    public Patch(String input) {
        this();
        this.fromText(input);
    }

    public Patch(String source, String target) {
        this(source, target, null);
    }

    public Patch(String source, String target, List diffs) {
        this();
        this.make(source, target, diffs);
    }

    public Patch make(String source, String target, List diffList) {
        Diff diff;
        List diffs = diffList;
        if (diffs == null && (diffs = (diff = new Diff(source, target)).compare()).size() > 2) {
            DiffCleanup.cleanupSemantic(diffs);
            DiffCleanup.cleanupEfficiency(diffs);
        }
        this.patches.clear();
        if (diffs.size() == 0) {
            return this;
        }
        PatchEntry patch = new PatchEntry();
        int charCount1 = 0;
        int charCount2 = 0;
        String prePatchText = source;
        String postPatchText = source;
        Iterator iter = diffs.iterator();
        int x = 0;
        while (iter.hasNext()) {
            Difference diff2 = (Difference)iter.next();
            EditType editType = diff2.getEditType();
            String diffText = diff2.getText();
            int len = diffText.length();
            if (!patch.hasDifferences() && !EditType.EQUAL.equals(editType)) {
                patch.setSourceStart(charCount1);
                patch.setTargetStart(charCount2);
            }
            if (EditType.INSERT.equals(editType)) {
                patch.addDifference(diff2);
                patch.adjustTargetLength(len);
                postPatchText = postPatchText.substring(0, charCount2) + diffText + postPatchText.substring(charCount2);
            } else if (EditType.DELETE.equals(editType)) {
                patch.adjustSourceLength(len);
                patch.addDifference(diff2);
                postPatchText = postPatchText.substring(0, charCount2) + postPatchText.substring(charCount2 + len);
            } else if (EditType.EQUAL.equals(editType) && len <= 2 * this.margin && patch.hasDifferences() && diffs.size() != x + 1) {
                patch.addDifference(diff2);
                patch.adjustSourceLength(len);
                patch.adjustTargetLength(len);
            }
            if (EditType.EQUAL.equals(editType) && len >= 2 * this.margin && patch.hasDifferences()) {
                patch.addContext(prePatchText);
                this.patches.add(patch);
                patch = new PatchEntry();
                prePatchText = postPatchText;
            }
            if (!EditType.INSERT.equals(editType)) {
                charCount1 += len;
            }
            if (!EditType.DELETE.equals(editType)) {
                charCount2 += len;
            }
            ++x;
        }
        if (patch.hasDifferences()) {
            patch.addContext(prePatchText);
            this.patches.add(patch);
        }
        return this;
    }

    public PatchResults apply(String text) {
        this.splitMax();
        boolean[] results = new boolean[this.patches.size()];
        String resultText = text;
        int delta = 0;
        int expectedLoc = 0;
        int startLoc = -1;
        String text1 = "";
        String text2 = "";
        int index1 = 0;
        int index2 = 0;
        int x = 0;
        Iterator patchIter = this.patches.iterator();
        while (patchIter.hasNext()) {
            PatchEntry aPatch = (PatchEntry)patchIter.next();
            expectedLoc = aPatch.getTargetStart() + delta;
            text1 = aPatch.getSourceText();
            Match match = new Match(resultText, text1, expectedLoc);
            startLoc = match.locate();
            if (startLoc == -1) {
                results[x] = false;
            } else {
                results[x] = true;
                delta = startLoc - expectedLoc;
                text2 = resultText.substring(startLoc, startLoc + text1.length());
                if (text1.equals(text2)) {
                    resultText = resultText.substring(0, startLoc) + aPatch.getTargetText() + resultText.substring(startLoc + text1.length());
                } else {
                    Diff diff = new Diff(text1, text2, false);
                    List diffs = diff.compare();
                    index1 = 0;
                    Iterator diffIter = aPatch.iterator();
                    while (diffIter.hasNext()) {
                        Difference aDiff = (Difference)diffIter.next();
                        EditType editType = aDiff.getEditType();
                        if (!EditType.EQUAL.equals(editType)) {
                            index2 = diff.xIndex(diffs, index1);
                        }
                        if (EditType.INSERT.equals(editType)) {
                            resultText = resultText.substring(0, startLoc + index2) + aDiff.getText() + resultText.substring(startLoc + index2);
                        } else if (EditType.DELETE.equals(editType)) {
                            resultText = resultText.substring(0, startLoc + index2) + resultText.substring(startLoc + diff.xIndex(diffs, index1 + aDiff.getText().length()));
                        }
                        if (EditType.DELETE.equals(editType)) continue;
                        index1 += aDiff.getText().length();
                    }
                }
            }
            ++x;
        }
        return new PatchResults(resultText, results);
    }

    public void splitMax() {
        PatchEntry bigPatch;
        int maxPatternLength = new Match().maxPatternLength();
        ListIterator<PatchEntry> pointer = this.patches.listIterator();
        PatchEntry patchEntry = bigPatch = pointer.hasNext() ? (PatchEntry)pointer.next() : null;
        while (bigPatch != null) {
            if (bigPatch.getSourceLength() <= maxPatternLength) {
                if (!pointer.hasNext()) break;
                bigPatch = (PatchEntry)pointer.next();
            }
            pointer.remove();
            int patchSize = maxPatternLength;
            int start1 = bigPatch.getSourceStart();
            int start2 = bigPatch.getTargetStart();
            String preContext = "";
            while (bigPatch.hasDifferences()) {
                PatchEntry patch = new PatchEntry();
                boolean empty = true;
                int len = preContext.length();
                patch.setSourceStart(start1 - len);
                patch.setTargetStart(start2 - len);
                if (len > 0) {
                    patch.setSourceLength(len);
                    patch.setTargetLength(len);
                    patch.addDifference(new Difference(EditType.EQUAL, preContext));
                }
                while (bigPatch.hasDifferences() && patch.getSourceLength() < patchSize - this.margin) {
                    Difference bigDiff = bigPatch.getFirstDifference();
                    EditType editType = bigDiff.getEditType();
                    String diffText = bigDiff.getText();
                    if (EditType.INSERT.equals(editType)) {
                        len = diffText.length();
                        patch.adjustTargetLength(len);
                        start2 += len;
                        patch.addDifference(bigPatch.removeFirstDifference());
                        empty = false;
                        continue;
                    }
                    diffText = diffText.substring(0, Math.min(diffText.length(), patchSize - patch.getSourceLength() - this.margin));
                    len = diffText.length();
                    patch.adjustSourceLength(len);
                    start1 += len;
                    if (EditType.EQUAL.equals(editType)) {
                        patch.adjustTargetLength(len);
                        start2 += len;
                    } else {
                        empty = false;
                    }
                    patch.addDifference(new Difference(editType, diffText));
                    if (diffText.equals(bigDiff.getText())) {
                        bigPatch.removeFirstDifference();
                        continue;
                    }
                    bigDiff.setText(bigDiff.getText().substring(len));
                }
                preContext = patch.getTargetText();
                preContext = preContext.substring(Math.max(0, preContext.length() - this.margin));
                String postcontext = null;
                postcontext = bigPatch.getSourceText().length() > this.margin ? bigPatch.getSourceText().substring(0, this.margin) : bigPatch.getSourceText();
                if (postcontext.length() > 0) {
                    patch.adjustSourceLength(postcontext.length());
                    patch.adjustTargetLength(postcontext.length());
                    if (patch.getDifferenceCount() > 0 && EditType.EQUAL.equals(patch.getLastDifference().getEditType())) {
                        Difference diff = patch.getLastDifference();
                        diff.appendText(postcontext);
                    } else {
                        patch.addDifference(new Difference(EditType.EQUAL, postcontext));
                    }
                }
                if (empty) continue;
                pointer.add(patch);
            }
            bigPatch = pointer.hasNext() ? (PatchEntry)pointer.next() : null;
        }
    }

    public String toText() {
        StringBuffer text = new StringBuffer();
        Iterator iter = this.patches.iterator();
        while (iter.hasNext()) {
            text.append(iter.next());
        }
        return text.toString();
    }

    public Patch fromText(String input) {
        this.patches.clear();
        String[] text = patchBoundaryPattern.split(input);
        for (int patchCount = 0; patchCount < text.length; ++patchCount) {
            this.patches.add(new PatchEntry(text[patchCount]));
        }
        return this;
    }

    public static class PatchResults {
        private String text;
        private boolean[] results;

        public PatchResults(String text, boolean[] results) {
            this.text = text;
            this.results = (boolean[])results.clone();
        }

        public boolean[] getResults() {
            return (boolean[])this.results.clone();
        }

        public String getText() {
            return this.text;
        }
    }
}

