/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.TreeNode;
import org.crosswire.jsword.passage.DefaultKeyList;

public class TreeKeyIndex
implements Activatable {
    private static final String EXTENSION_INDEX = ".idx";
    private static final String EXTENSION_DATA = ".dat";
    private SwordBookMetaData bmd;
    private File idxFile;
    private File datFile;
    private RandomAccessFile idxRaf;
    private RandomAccessFile datRaf;
    private boolean active;
    private static final Logger log = Logger.getLogger((Class)TreeKeyIndex.class);

    public TreeKeyIndex(SwordBookMetaData sbmd) throws BookException {
        this.bmd = sbmd;
        String path = this.getExpandedDataPath();
        this.idxFile = new File(path + EXTENSION_INDEX);
        this.datFile = new File(path + EXTENSION_DATA);
        if (!this.idxFile.canRead()) {
            throw new BookException((MsgBase)Msg.READ_FAIL, new Object[]{this.idxFile.getAbsolutePath()});
        }
        if (!this.datFile.canRead()) {
            throw new BookException((MsgBase)Msg.READ_FAIL, new Object[]{this.datFile.getAbsolutePath()});
        }
    }

    public TreeNode getRoot() throws IOException {
        return this.getTreeNode(this.getOffset(0));
    }

    public TreeNode getParent(TreeNode node) throws IOException {
        return this.getTreeNode(this.getOffset(node.getParent()));
    }

    public TreeNode getFirstChild(TreeNode node) throws IOException {
        return this.getTreeNode(this.getOffset(node.getFirstChild()));
    }

    public TreeNode getNextSibling(TreeNode node) throws IOException {
        return this.getTreeNode(this.getOffset(node.getNextSibling()));
    }

    private int getOffset(int index) throws IOException {
        if (index == -1) {
            return -1;
        }
        this.checkActive();
        byte[] buffer = SwordUtil.readRAF(this.idxRaf, index, 4);
        return SwordUtil.decodeLittleEndian32(buffer, 0);
    }

    private TreeNode getTreeNode(int offset) throws IOException {
        TreeNode node = new TreeNode(offset);
        if (offset == -1) {
            return node;
        }
        this.checkActive();
        byte[] buffer = SwordUtil.readRAF(this.datRaf, offset, 12);
        node.setParent(SwordUtil.decodeLittleEndian32(buffer, 0));
        node.setNextSibling(SwordUtil.decodeLittleEndian32(buffer, 4));
        node.setFirstChild(SwordUtil.decodeLittleEndian32(buffer, 8));
        buffer = SwordUtil.readUntilRAF(this.datRaf, (byte)0);
        int size = buffer.length;
        if (buffer[size - 1] == 0) {
            --size;
        }
        DefaultKeyList key = new DefaultKeyList(null, this.bmd.getName());
        node.setName(SwordUtil.decode(key, buffer, size, this.bmd.getBookCharset()).trim());
        buffer = SwordUtil.readNextRAF(this.datRaf, 2);
        int userDataSize = SwordUtil.decodeLittleEndian16(buffer, 0);
        if (userDataSize > 0) {
            node.setUserData(SwordUtil.readNextRAF(this.datRaf, userDataSize));
        }
        return node;
    }

    public final void activate(Lock lock) {
        try {
            this.idxRaf = new RandomAccessFile(this.idxFile, "r");
            this.datRaf = new RandomAccessFile(this.datFile, "r");
        }
        catch (IOException ex) {
            log.error("failed to open files", (Throwable)ex);
            this.idxRaf = null;
            this.datRaf = null;
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate(Lock lock) {
        try {
            if (this.idxRaf != null) {
                this.idxRaf.close();
            }
            if (this.datRaf != null) {
                this.datRaf.close();
            }
        }
        catch (IOException ex) {
            log.error("failed to close nt files", (Throwable)ex);
        }
        finally {
            this.idxRaf = null;
            this.datRaf = null;
        }
        this.active = false;
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    private String getExpandedDataPath() throws BookException {
        URI loc = NetUtil.lengthenURI((URI)this.bmd.getLibrary(), (String)this.bmd.getProperty(ConfigEntryType.DATA_PATH));
        if (loc == null) {
            throw new BookException(Msg.MISSING_FILE);
        }
        return new File(loc.getPath()).getAbsolutePath();
    }
}

