/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import java.net.URI;
import java.net.URISyntaxException;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.WebResource;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.sword.AbstractSwordInstaller;
import org.crosswire.jsword.book.install.sword.Msg;

public class HttpSwordInstaller
extends AbstractSwordInstaller {
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getType() {
        return "sword-http";
    }

    public int getSize(Book book) {
        return NetUtil.getSize((URI)this.toRemoteURI(book), (String)this.proxyHost, (Integer)this.proxyPort);
    }

    public URI toRemoteURI(Book book) {
        try {
            return new URI("http", this.host, this.packageDirectory + '/' + book.getInitials() + ".zip", null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected void download(Progress job, String dir, String file, URI dest) throws InstallException {
        block3: {
            try {
                URI uri = new URI("http", this.host, dir + '/' + file, null);
                this.copy(job, uri, dest);
            }
            catch (LucidException ex) {
                throw new InstallException((MsgBase)Msg.MISSING_FILE, ex);
            }
            catch (URISyntaxException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
    }

    private void copy(Progress job, URI uri, URI dest) throws LucidException {
        if (job != null) {
            job.setSectionName(Msg.JOB_DOWNLOADING.toString());
        }
        WebResource wr = new WebResource(uri, this.proxyHost, this.proxyPort);
        wr.copy(dest);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpSwordInstaller)) {
            return false;
        }
        HttpSwordInstaller that = (HttpSwordInstaller)object;
        return super.equals(that);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static {
        $assertionsDisabled = !HttpSwordInstaller.class.desiredAssertionStatus();
    }
}

