/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.Serializable;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.CompressionType;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.GenBookBackend;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.RawBackend;
import org.crosswire.jsword.book.sword.RawLDBackend;
import org.crosswire.jsword.book.sword.SwordBook;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordDailyDevotion;
import org.crosswire.jsword.book.sword.SwordDictionary;
import org.crosswire.jsword.book.sword.SwordGenBook;
import org.crosswire.jsword.book.sword.ZLDBackend;

public abstract class BookType
implements Serializable {
    public static final BookType RAW_TEXT;
    public static final BookType Z_TEXT;
    public static final BookType RAW_COM;
    public static final BookType Z_COM;
    public static final BookType HREF_COM;
    public static final BookType RAW_FILES;
    public static final BookType RAW_LD;
    public static final BookType RAW_LD4;
    public static final BookType Z_LD;
    public static final BookType RAW_GEN_BOOK;
    private String name;
    private BookCategory type;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final BookType[] VALUES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BookType(String name, BookCategory type) {
        this.name = name;
        this.type = type;
    }

    public static BookType getBookType(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            BookType mod = VALUES[i];
            if (!mod.name.equalsIgnoreCase(name)) continue;
            return mod;
        }
        throw new IllegalArgumentException(Msg.UNDEFINED_BOOK_TYPE.toString(name));
    }

    public BookCategory getBookCategory() {
        return this.type;
    }

    public boolean isSupported(SwordBookMetaData sbmd) {
        return this.type != null && this.isBackendSupported(sbmd);
    }

    protected boolean isBackendSupported(SwordBookMetaData sbmd) {
        return sbmd != null;
    }

    public Book createBook(SwordBookMetaData sbmd) throws BookException {
        return this.getBook(sbmd, this.getBackend(sbmd));
    }

    protected abstract Book getBook(SwordBookMetaData var1, AbstractBackend var2);

    protected abstract AbstractBackend getBackend(SwordBookMetaData var1) throws BookException;

    protected static AbstractBackend getCompressedBackend(SwordBookMetaData sbmd) throws BookException {
        String cStr = sbmd.getProperty(ConfigEntryType.COMPRESS_TYPE);
        if (cStr != null) {
            return CompressionType.fromString(cStr).getBackend(sbmd);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new BookException((MsgBase)Msg.COMPRESSION_UNSUPPORTED, new Object[]{"no compression given"});
    }

    protected static boolean isCompressedBackendSupported(SwordBookMetaData sbmd) {
        String cStr = sbmd.getProperty(ConfigEntryType.COMPRESS_TYPE);
        if (cStr != null) {
            return CompressionType.fromString(cStr).isSupported();
        }
        return false;
    }

    public static BookType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            BookType mod = VALUES[i];
            if (!mod.name.equalsIgnoreCase(name)) continue;
            return mod;
        }
        throw new ClassCastException(Msg.UNDEFINED_DATATYPE.toString(name));
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !BookType.class.desiredAssertionStatus();
        RAW_TEXT = new BookType("RawText", BookCategory.BIBLE){
            private static final long serialVersionUID = 3544385920414529336L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                return new SwordBook(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return new RawBackend(sbmd);
            }
        };
        Z_TEXT = new BookType("zText", BookCategory.BIBLE){
            private static final long serialVersionUID = 3257846571620906039L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                return new SwordBook(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return 2.getCompressedBackend(sbmd);
            }

            protected boolean isBackendSupported(SwordBookMetaData sbmd) {
                return 2.isCompressedBackendSupported(sbmd);
            }
        };
        RAW_COM = new BookType("RawCom", BookCategory.COMMENTARY){
            private static final long serialVersionUID = 3258129141898294837L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                return new SwordBook(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return new RawBackend(sbmd);
            }
        };
        Z_COM = new BookType("zCom", BookCategory.COMMENTARY){
            private static final long serialVersionUID = 3257569516166002487L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                return new SwordBook(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return 4.getCompressedBackend(sbmd);
            }

            protected boolean isBackendSupported(SwordBookMetaData sbmd) {
                return 4.isCompressedBackendSupported(sbmd);
            }
        };
        HREF_COM = new BookType("HREFCom", BookCategory.COMMENTARY){
            private static final long serialVersionUID = 3256439209706338354L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                return new SwordBook(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return new RawBackend(sbmd);
            }
        };
        RAW_FILES = new BookType("RawFiles", BookCategory.COMMENTARY){
            private static final long serialVersionUID = 3256446901875325236L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                return new SwordBook(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return new RawBackend(sbmd);
            }
        };
        RAW_LD = new BookType("RawLD", BookCategory.DICTIONARY){
            private static final long serialVersionUID = 3257290240195442745L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                if (sbmd.getBookCategory().equals(BookCategory.DAILY_DEVOTIONS)) {
                    return new SwordDailyDevotion(sbmd, backend);
                }
                return new SwordDictionary(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return new RawLDBackend(sbmd, 2);
            }
        };
        RAW_LD4 = new BookType("RawLD4", BookCategory.DICTIONARY){
            private static final long serialVersionUID = 3689067356945331762L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                if (sbmd.getBookCategory().equals(BookCategory.DAILY_DEVOTIONS)) {
                    return new SwordDailyDevotion(sbmd, backend);
                }
                return new SwordDictionary(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return new RawLDBackend(sbmd, 4);
            }
        };
        Z_LD = new BookType("zLD", BookCategory.DICTIONARY){
            private static final long serialVersionUID = 3691037673259414067L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                if (sbmd.getBookCategory().equals(BookCategory.DAILY_DEVOTIONS)) {
                    return new SwordDailyDevotion(sbmd, backend);
                }
                return new SwordDictionary(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return new ZLDBackend(sbmd);
            }
        };
        RAW_GEN_BOOK = new BookType("RawGenBook", BookCategory.GENERAL_BOOK){
            private static final long serialVersionUID = 3257290218703892528L;

            protected Book getBook(SwordBookMetaData sbmd, AbstractBackend backend) {
                return new SwordGenBook(sbmd, backend);
            }

            protected AbstractBackend getBackend(SwordBookMetaData sbmd) throws BookException {
                return new GenBookBackend(sbmd);
            }

            protected boolean isBackendSupported(SwordBookMetaData sbmd) {
                return true;
            }
        };
        VALUES = new BookType[]{RAW_TEXT, Z_TEXT, RAW_COM, Z_COM, RAW_COM, HREF_COM, RAW_FILES, RAW_LD, RAW_LD4, Z_LD, RAW_GEN_BOOK};
    }
}

