/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.readings;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.URLFilter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.basic.AbstractBookDriver;
import org.crosswire.jsword.book.readings.ReadingsBook;

public class ReadingsBookDriver
extends AbstractBookDriver {
    private Book[] books;
    public static final String DIR_READINGS = "readings";
    private static final BookDriver INSTANCE = new ReadingsBookDriver();

    public ReadingsBookDriver() {
        ArrayList<ReadingsBook> bookList = new ArrayList<ReadingsBook>();
        String[] installedBooks = this.getInstalledReadingsSets();
        for (int i = 0; i < installedBooks.length; ++i) {
            bookList.add(new ReadingsBook(this, installedBooks[i], BookCategory.DAILY_DEVOTIONS));
        }
        this.books = bookList.toArray(new Book[bookList.size()]);
    }

    public Book[] getBooks() {
        Book[] copy = new Book[this.books.length];
        System.arraycopy(this.books, 0, copy, 0, this.books.length);
        return copy;
    }

    public String getDriverName() {
        return "Readings";
    }

    public static BookDriver instance() {
        return INSTANCE;
    }

    public String[] getInstalledReadingsSets() {
        try {
            URL index = ResourceUtil.getResource((Class)ReadingsBookDriver.class, (String)"readings.txt");
            return NetUtil.listByIndexFile((URL)index, (URLFilter)new URLFilter(){

                public boolean accept(String name) {
                    return true;
                }
            });
        }
        catch (IOException ex) {
            return new String[0];
        }
    }
}

