/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public final class StringUtil {
    public static final String NEWLINE = System.getProperty("line.separator", "\r\n");
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StringUtil() {
    }

    public static String read(Reader in) throws IOException {
        String line;
        StringBuffer retcode = new StringBuffer();
        BufferedReader din = new BufferedReader(in);
        while ((line = din.readLine()) != null) {
            retcode.append(line);
            retcode.append(NEWLINE);
        }
        return retcode.toString();
    }

    public static String createTitle(String variable) {
        StringBuffer retcode = new StringBuffer();
        boolean lastlower = false;
        boolean lastspace = true;
        for (int i = 0; i < variable.length(); ++i) {
            char c = variable.charAt(i);
            if (lastlower && Character.isUpperCase(c) && !lastspace) {
                retcode.append(' ');
            }
            boolean bl = lastlower = !Character.isUpperCase(c);
            if (lastspace) {
                c = Character.toUpperCase(c);
            }
            if (c == '_') {
                c = ' ';
            }
            if (!lastspace || c != ' ') {
                retcode.append(c);
            }
            lastspace = c == ' ';
        }
        return retcode.toString();
    }

    public static String getInitials(String sentence) {
        String[] words = StringUtil.split(sentence);
        StringBuffer retcode = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            char first = '\u0000';
            for (int j = 0; first == '\u0000' && j < word.length(); ++j) {
                char c = word.charAt(j);
                if (!Character.isLetter(c)) continue;
                first = c;
            }
            if (first == '\u0000') continue;
            retcode.append(first);
        }
        return retcode.toString();
    }

    public static String[] split(String str) {
        return StringUtil.split(str, null, -1);
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return (String[])EMPTY_STRING_ARRAY.clone();
        }
        int len = str.length();
        if (len == 0) {
            return (String[])EMPTY_STRING_ARRAY.clone();
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] splitAll(String str, char separatorChar) {
        if (str == null) {
            return (String[])EMPTY_STRING_ARRAY.clone();
        }
        int len = str.length();
        if (len == 0) {
            return (String[])EMPTY_STRING_ARRAY.clone();
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                list.add(str.substring(start, i));
                start = ++i;
                match = false;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtil.split(str, separatorChars, -1);
    }

    public static String[] split(String str, String separatorChars, int max) {
        if (str == null) {
            return (String[])EMPTY_STRING_ARRAY.clone();
        }
        int len = str.length();
        if (len == 0) {
            return (String[])EMPTY_STRING_ARRAY.clone();
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = len;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = len;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match) {
                        if (sizePlus1++ == max) {
                            i = len;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(Object[] array, String aSeparator) {
        int arraySize;
        String separator = aSeparator;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : arraySize * ((array[0] == null ? 16 : array[0].toString().length()) + separator.length());
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }
}

