/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;

public abstract class OSType
implements Serializable {
    public static final OSType MAC;
    public static final OSType WIN32;
    public static final OSType DEFAULT;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final OSType[] VALUES;
    protected URL userArea;
    private static final String WIN32_USER_DATA_AREA = "Application Data";
    private static final String MAC_USER_DATA_AREA = "Library/Application Support";
    private static OSType osType;
    private static URL userHome;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OSType(String name) {
        this.name = name;
    }

    public abstract URL getUserArea();

    public abstract URL getUserAreaFolder(String var1, String var2);

    public static URL getUserHome() {
        block3: {
            if (userHome == null) {
                try {
                    userHome = new URL("file", null, System.getProperty("user.home"));
                }
                catch (MalformedURLException e) {
                    log.fatal("Failed to find user's home folder", (Throwable)e);
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return userHome;
    }

    public int toInteger() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!this.equals(VALUES[i])) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public static OSType getOSType() {
        return osType;
    }

    public static OSType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            OSType o = VALUES[i];
            if (!o.name.startsWith(name)) continue;
            return o;
        }
        return DEFAULT;
    }

    public static OSType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !OSType.class.desiredAssertionStatus();
        MAC = new OSType("Mac OS X"){
            private static final long serialVersionUID = -1575982665011980783L;

            public URL getUserArea() {
                if (this.userArea == null) {
                    this.userArea = NetUtil.lengthenURL((URL)1.getUserHome(), (String)OSType.MAC_USER_DATA_AREA);
                }
                return this.userArea;
            }

            public URL getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
                return NetUtil.lengthenURL((URL)this.getUserArea(), (String)visibleFolderName);
            }
        };
        WIN32 = new OSType("Windows"){
            private static final long serialVersionUID = 2448098399487879399L;

            public URL getUserArea() {
                if (this.userArea == null) {
                    this.userArea = NetUtil.lengthenURL((URL)2.getUserHome(), (String)OSType.WIN32_USER_DATA_AREA);
                }
                return this.userArea;
            }

            public URL getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
                return NetUtil.lengthenURL((URL)this.getUserArea(), (String)visibleFolderName);
            }
        };
        DEFAULT = new OSType("*nix"){
            private static final long serialVersionUID = 8260119208395182688L;

            public URL getUserArea() {
                return 3.getUserHome();
            }

            public URL getUserAreaFolder(String hiddenFolderName, String visibleFolderName) {
                return NetUtil.lengthenURL((URL)this.getUserArea(), (String)hiddenFolderName);
            }
        };
        VALUES = new OSType[]{MAC, WIN32, DEFAULT};
        osType = OSType.fromString(System.getProperty("os.name"));
        log = Logger.getLogger((Class)OSType.class);
    }
}

