/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.filter.FilterException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.ReadOnlyKeyList;
import org.jdom.Content;
import org.jdom.Element;

public class SwordDictionary
extends AbstractBook {
    private static final Pattern STRONGS_PATTERN;
    private static final DecimalFormat ZERO_PAD;
    private Key global;
    private boolean active;
    private Map map;
    private Key set;
    private AbstractBackend backend;
    private SwordBookMetaData sbmd;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected SwordDictionary(SwordBookMetaData sbmd, AbstractBackend backend) {
        super(sbmd);
        this.sbmd = sbmd;
        this.backend = backend;
        this.map = null;
        this.set = null;
        this.global = null;
        this.active = false;
    }

    public final void activate(Lock lock) {
        super.activate(lock);
        this.set = this.backend.readIndex();
        this.map = new HashMap();
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            this.map.put(key.getName(), key);
        }
        this.global = new ReadOnlyKeyList(this.set, false);
        this.active = true;
    }

    public final void deactivate(Lock lock) {
        super.deactivate(lock);
        this.map = null;
        this.set = null;
        this.global = null;
        Activator.deactivate((Activatable)this.backend);
        this.active = false;
    }

    public BookData getData(Key key) throws BookException {
        this.checkActive();
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.backend == null) {
            throw new AssertionError();
        }
        try {
            Element osis = OSISUtil.createOsisFramework(this.getBookMetaData());
            Element text = osis.getChild("osisText");
            Element div = OSISUtil.factory().createDiv();
            Element title = OSISUtil.factory().createTitle();
            title.addContent(key.getName());
            div.addContent((Content)title);
            text.addContent((Content)div);
            String txt = this.backend.getRawText(key);
            List osisContent = this.sbmd.getFilter().toOSIS(this, key, txt);
            div.addContent((Collection)osisContent);
            return new BookData(osis, (Book)this, key);
        }
        catch (FilterException ex) {
            throw new BookException((MsgBase)Msg.FILTER_FAIL, (Throwable)((Object)ex));
        }
    }

    public String getRawData(Key key) throws BookException {
        this.checkActive();
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.backend == null) {
            throw new AssertionError();
        }
        return this.backend.getRawText(key);
    }

    public Key getGlobalKeyList() {
        this.checkActive();
        return this.global;
    }

    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    public Key getKey(String text) throws NoSuchKeyException {
        String keyName;
        this.checkActive();
        Key key = (Key)this.map.get(text);
        if (key != null) {
            return key;
        }
        key = this.getStrongsKey(text);
        if (key != null) {
            return key;
        }
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            keyName = (String)iter.next();
            if (!keyName.equalsIgnoreCase(text)) continue;
            return (Key)this.map.get(keyName);
        }
        iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            keyName = (String)iter.next();
            if (!keyName.startsWith(text)) continue;
            return (Key)this.map.get(keyName);
        }
        iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            keyName = (String)iter.next();
            if (keyName.indexOf(text) == -1) continue;
            return (Key)this.map.get(keyName);
        }
        throw new NoSuchKeyException((MsgBase)Msg.NO_KEY, new Object[]{text, this.getInitials()});
    }

    private Key getStrongsKey(String txt) {
        String text = txt;
        Matcher m = STRONGS_PATTERN.matcher(text);
        if (!m.matches()) {
            return null;
        }
        int pos = text.length() - 1;
        if (Character.isLetter(text.charAt(pos))) {
            text = text.substring(0, pos);
        }
        int strongsNumber = Integer.parseInt(text.substring(1));
        Key key = null;
        String internalName = this.sbmd.getInitials();
        if ("StrongsGreek".equals(internalName)) {
            key = (Key)this.map.get(ZERO_PAD.format(strongsNumber));
        } else if ("StrongsHebrew".equals(internalName)) {
            key = (Key)this.map.get(ZERO_PAD.format(strongsNumber));
        }
        return key;
    }

    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }

    private void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    static {
        $assertionsDisabled = !SwordDictionary.class.desiredAssertionStatus();
        STRONGS_PATTERN = Pattern.compile("^[GH]\\d+[a-z]?$");
        ZERO_PAD = new DecimalFormat("00000");
    }
}

