/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.versification.BibleInfo;
import org.crosswire.jsword.versification.Msg;

public final class OSISNames {
    private static Pattern normPattern;
    private static final Locale OSIS_LOCALE;
    static final OSISNames instance;
    private static final String OSIS_KEY = "OSIS.";
    private static String[] osisBooks;
    private static Map osisMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    private OSISNames() {
        OSISNames.initialize();
    }

    public static String getName(int book) throws NoSuchVerseException {
        try {
            return osisBooks[book - 1];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NoSuchVerseException((MsgBase)Msg.BOOKS_BOOK, new Object[]{new Integer(book)});
        }
    }

    public static int getBookNumber(String find) {
        String match = OSISNames.normalize(find);
        Integer bookNum = (Integer)osisMap.get(match);
        if (bookNum != null) {
            return bookNum;
        }
        return -1;
    }

    public static boolean isBookName(String find) {
        return OSISNames.getBookNumber(find) != -1;
    }

    private static String normalize(String str) {
        return normPattern.matcher(str).replaceAll("").toLowerCase(OSIS_LOCALE);
    }

    private static void initialize() {
        int booksInBible = BibleInfo.booksInBible();
        osisBooks = new String[booksInBible];
        osisMap = new HashMap(booksInBible);
        ResourceBundle resources = ResourceBundle.getBundle(OSISNames.class.getName(), OSIS_LOCALE, (ClassLoader)CWClassLoader.instance((Class)OSISNames.class));
        for (int i = 0; i < osisBooks.length; ++i) {
            OSISNames.osisBooks[i] = OSISNames.getString(resources, OSIS_KEY + (i + 1));
            osisMap.put(OSISNames.normalize(osisBooks[i]), new Integer(i + 1));
        }
    }

    private static String getString(ResourceBundle resources, String key) {
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    static {
        $assertionsDisabled = !OSISNames.class.desiredAssertionStatus();
        normPattern = Pattern.compile("[. ]");
        OSIS_LOCALE = new Locale("en");
        instance = new OSISNames();
    }
}

