/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageEvent;
import org.crosswire.jsword.passage.PassageListener;
import org.crosswire.jsword.passage.PassageUtil;
import org.crosswire.jsword.passage.RangedPassage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.passage.VerseRangeFactory;
import org.crosswire.jsword.versification.BibleInfo;

public abstract class AbstractPassage
implements Passage {
    private static final Logger log;
    protected static final int BITWISE = 0;
    protected static final int DISTINCT = 1;
    protected static final int RANGED = 2;
    protected static final int METHOD_COUNT = 3;
    private transient Key parent;
    protected transient List listeners;
    protected transient String originalName;
    protected transient int suppressEvents;
    protected transient int skipNormalization;
    public static final String REF_ALLOWED_DELIMS = ",;\n\r\t";
    public static final String REF_PREF_DELIM = ", ";
    public static final String REF_OSIS_DELIM = " ";
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractPassage() {
        this(null);
    }

    protected AbstractPassage(String passageName) {
        this.originalName = passageName;
        this.listeners = new ArrayList();
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof Passage)) {
            log.warn("Can't compare a Passage to a " + obj.getClass().getName());
            return -1;
        }
        Passage thatref = (Passage)obj;
        if (thatref.countVerses() == 0) {
            if (this.countVerses() == 0) {
                return 0;
            }
            return -1;
        }
        if (this.countVerses() == 0) {
            return 1;
        }
        Verse thatfirst = thatref.getVerseAt(0);
        Verse thisfirst = this.getVerseAt(0);
        return thisfirst.compareTo(thatfirst);
    }

    public Object clone() {
        AbstractPassage copy;
        block2: {
            copy = null;
            try {
                copy = (AbstractPassage)super.clone();
                copy.listeners = new ArrayList();
                copy.listeners.addAll(this.listeners);
                copy.originalName = this.originalName;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Passage)) {
            return false;
        }
        Passage ref = (Passage)obj;
        return ref.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getName() {
        if (PassageUtil.isPersistentNaming() && this.originalName != null) {
            return this.originalName;
        }
        StringBuffer retcode = new StringBuffer();
        Iterator it = this.rangeIterator(RestrictionType.NONE);
        Verse current = null;
        while (it.hasNext()) {
            VerseRange range = (VerseRange)it.next();
            retcode.append(range.getName(current));
            if (it.hasNext()) {
                retcode.append(REF_PREF_DELIM);
            }
            current = range.getStart();
        }
        return retcode.toString();
    }

    public String getName(Key base) {
        return this.getName();
    }

    public String getOsisRef() {
        StringBuffer retcode = new StringBuffer();
        Iterator it = this.rangeIterator(RestrictionType.NONE);
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Key range = (Key)it.next();
            retcode.append(range.getOsisRef());
            hasNext = it.hasNext();
            if (!hasNext) continue;
            retcode.append(REF_OSIS_DELIM);
        }
        return retcode.toString();
    }

    public String getOsisID() {
        StringBuffer retcode = new StringBuffer();
        Iterator it = this.rangeIterator(RestrictionType.NONE);
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Key range = (Key)it.next();
            retcode.append(range.getOsisID());
            hasNext = it.hasNext();
            if (!hasNext) continue;
            retcode.append(REF_OSIS_DELIM);
        }
        return retcode.toString();
    }

    public String toString() {
        return this.getName();
    }

    public String getOverview() {
        int verse_count = this.countVerses();
        int book_count = this.booksInPassage();
        String verses = verse_count == 1 ? Msg.ABSTRACT_VERSE_SINGULAR.toString() : Msg.ABSTRACT_VERSE_PLURAL.toString();
        String books = book_count == 1 ? Msg.ABSTRACT_BOOK_SINGULAR.toString() : Msg.ABSTRACT_BOOK_PLURAL.toString();
        return verse_count + REF_OSIS_DELIM + verses + REF_OSIS_DELIM + book_count + REF_OSIS_DELIM + books;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public int countVerses() {
        int count = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    public int countRanges(RestrictionType restrict) {
        int count = 0;
        Iterator it = this.rangeIterator(restrict);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public int booksInPassage() {
        int current_book = 0;
        int book_count = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Verse verse = (Verse)it.next();
            if (current_book == verse.getBook()) continue;
            current_book = verse.getBook();
            ++book_count;
        }
        return book_count;
    }

    public int chaptersInPassage(int book) throws NoSuchVerseException {
        if (book != 0) {
            BibleInfo.validate(book, 1, 1);
        }
        int current_chapter = 0;
        int chapter_count = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Verse verse = (Verse)it.next();
            if (book != 0 && verse.getBook() != book || current_chapter == verse.getChapter()) continue;
            current_chapter = verse.getChapter();
            ++chapter_count;
        }
        return chapter_count;
    }

    public int versesInPassage(int book, int chapter) throws NoSuchVerseException {
        BibleInfo.validate(book == 0 ? 1 : book, chapter == 0 ? 1 : chapter, 1);
        int verse_count = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Verse verse = (Verse)it.next();
            if (book != 0 && verse.getBook() != book || chapter != 0 && verse.getChapter() != chapter) continue;
            ++verse_count;
        }
        return verse_count;
    }

    public Verse getVerseAt(int offset) throws ArrayIndexOutOfBoundsException {
        Iterator it = this.iterator();
        Object retcode = null;
        for (int i = 0; i <= offset; ++i) {
            if (!it.hasNext()) {
                Object[] params = new Object[]{new Integer(offset), new Integer(this.countVerses())};
                throw new ArrayIndexOutOfBoundsException(Msg.ABSTRACT_INDEX.toString(params));
            }
            retcode = it.next();
        }
        return retcode;
    }

    public VerseRange getRangeAt(int offset, RestrictionType restrict) throws ArrayIndexOutOfBoundsException {
        Iterator it = this.rangeIterator(restrict);
        Object retcode = null;
        for (int i = 0; i <= offset; ++i) {
            if (!it.hasNext()) {
                Object[] params = new Object[]{new Integer(offset), new Integer(this.countVerses())};
                throw new ArrayIndexOutOfBoundsException(Msg.ABSTRACT_INDEX.toString(params));
            }
            retcode = it.next();
        }
        return retcode;
    }

    public Iterator rangeIterator(RestrictionType restrict) {
        return new VerseRangeIterator(this.iterator(), restrict);
    }

    public boolean containsAll(Passage that) {
        Iterator that_it = null;
        that_it = that instanceof RangedPassage ? ((RangedPassage)that).rangeIterator(RestrictionType.NONE) : that.iterator();
        while (that_it.hasNext()) {
            if (this.contains((Key)that_it.next())) continue;
            return false;
        }
        return true;
    }

    public Passage trimVerses(int count) {
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        int i = 0;
        boolean overflow = false;
        Passage remainder = (Passage)this.clone();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Key verse = (Key)it.next();
            if (++i > count) {
                this.remove(verse);
                overflow = true;
                continue;
            }
            remainder.remove(verse);
        }
        this.lowerNormalizeProtection();
        if (overflow) {
            return remainder;
        }
        return null;
    }

    public Passage trimRanges(int count, RestrictionType restrict) {
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        int i = 0;
        boolean overflow = false;
        Passage remainder = (Passage)this.clone();
        Iterator it = this.rangeIterator(restrict);
        while (it.hasNext()) {
            Key range = (Key)it.next();
            if (++i > count) {
                this.remove(range);
                overflow = true;
                continue;
            }
            remainder.remove(range);
        }
        this.lowerNormalizeProtection();
        if (overflow) {
            return remainder;
        }
        return null;
    }

    public void addAll(Key key) {
        Passage that = KeyUtil.getPassage(key);
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        Iterator that_it = null;
        that_it = that instanceof RangedPassage ? that.rangeIterator(RestrictionType.NONE) : that.iterator();
        while (that_it.hasNext()) {
            this.add((Key)that_it.next());
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppresionAndTest()) {
            this.fireIntervalAdded(this, that.getVerseAt(0), that.getVerseAt(that.countVerses() - 1));
        }
    }

    public void removeAll(Key key) {
        Passage that = KeyUtil.getPassage(key);
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        Iterator that_it = null;
        that_it = that instanceof RangedPassage ? that.rangeIterator(RestrictionType.NONE) : that.iterator();
        while (that_it.hasNext()) {
            this.remove((Key)that_it.next());
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppresionAndTest()) {
            this.fireIntervalRemoved(this, that.getVerseAt(0), that.getVerseAt(that.countVerses() - 1));
        }
    }

    public void retainAll(Key key) {
        Passage that = KeyUtil.getPassage(key);
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        Passage temp = (Passage)this.clone();
        Iterator it = temp.iterator();
        while (it.hasNext()) {
            Key verse = (Key)it.next();
            if (that.contains(verse)) continue;
            this.remove(verse);
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppresionAndTest()) {
            this.fireIntervalRemoved(this, null, null);
        }
    }

    public void clear() {
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        this.remove(VerseRange.getWholeBibleVerseRange());
        if (this.lowerEventSuppresionAndTest()) {
            this.fireIntervalRemoved(this, null, null);
        }
    }

    public void blur(int verses, RestrictionType restrict) {
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        Passage temp = (Passage)this.clone();
        Iterator it = temp.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            VerseRange range = restrict.blur((VerseRange)it.next(), verses, verses);
            this.add(range);
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppresionAndTest()) {
            this.fireIntervalAdded(this, null, null);
        }
    }

    public void writeDescription(Writer out) throws IOException {
        BufferedWriter bout = new BufferedWriter(out);
        Iterator it = this.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            Key range = (Key)it.next();
            bout.write(range.getName());
            bout.newLine();
        }
        bout.flush();
    }

    public void readDescription(Reader in) throws IOException, NoSuchVerseException {
        String line;
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        int count = 0;
        BufferedReader bin = new BufferedReader(in);
        while ((line = bin.readLine()) != null) {
            ++count;
            this.addVerses(line);
        }
        if (count == 0) {
            return;
        }
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppresionAndTest()) {
            this.fireIntervalAdded(this, this.getVerseAt(0), this.getVerseAt(this.countVerses() - 1));
        }
    }

    public void optimizeReads() {
    }

    protected void optimizeWrites() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassageListener(PassageListener li) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePassageListener(PassageListener li) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(li);
        }
    }

    public boolean contains(Key key) {
        Passage ref = KeyUtil.getPassage(key);
        return this.containsAll(ref);
    }

    public int getChildCount() {
        return this.countVerses();
    }

    public int indexOf(Key that) {
        int index = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Key key = (Key)it.next();
            if (key.equals(that)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean canHaveChildren() {
        return false;
    }

    public Key get(int index) {
        return this.getVerseAt(index);
    }

    public Key getParent() {
        return this.parent;
    }

    public void setParent(Key parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIntervalAdded(Object source, Verse start, Verse end) {
        ArrayList temp;
        if (this.suppressEvents != 0) {
            return;
        }
        PassageEvent ev = new PassageEvent(source, 1, start, end);
        List list = this.listeners;
        synchronized (list) {
            temp = new ArrayList();
            temp.addAll(this.listeners);
        }
        for (int i = 0; i < temp.size(); ++i) {
            PassageListener rl = (PassageListener)temp.get(i);
            rl.versesAdded(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireIntervalRemoved(Object source, Verse start, Verse end) {
        ArrayList temp;
        if (this.suppressEvents != 0) {
            return;
        }
        PassageEvent ev = new PassageEvent(source, 2, start, end);
        List list = this.listeners;
        synchronized (list) {
            temp = new ArrayList();
            temp.addAll(this.listeners);
        }
        for (int i = 0; i < temp.size(); ++i) {
            PassageListener rl = (PassageListener)temp.get(i);
            rl.versesRemoved(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContentsChanged(Object source, Verse start, Verse end) {
        ArrayList temp;
        if (this.suppressEvents != 0) {
            return;
        }
        PassageEvent ev = new PassageEvent(source, 0, start, end);
        List list = this.listeners;
        synchronized (list) {
            temp = new ArrayList();
            temp.addAll(this.listeners);
        }
        for (int i = 0; i < temp.size(); ++i) {
            PassageListener rl = (PassageListener)temp.get(i);
            rl.versesChanged(ev);
        }
    }

    protected void addVerses(String refs) throws NoSuchVerseException {
        this.optimizeWrites();
        String[] parts = StringUtil.split((String)refs, (String)REF_ALLOWED_DELIMS);
        if (parts.length == 0) {
            return;
        }
        VerseRange basis = VerseRangeFactory.fromString(parts[0].trim());
        this.add(basis);
        for (int i = 1; i < parts.length; ++i) {
            VerseRange next = VerseRangeFactory.fromString(parts[i].trim(), basis);
            this.add(next);
            basis = next;
        }
    }

    void normalize() {
    }

    public void raiseNormalizeProtection() {
        ++this.skipNormalization;
        if (this.skipNormalization > 10) {
            log.warn("skip_normalization=" + this.skipNormalization);
        }
    }

    public void lowerNormalizeProtection() {
        --this.skipNormalization;
        if (this.skipNormalization == 0) {
            this.normalize();
        }
        if (!$assertionsDisabled && this.skipNormalization < 0) {
            throw new AssertionError();
        }
    }

    public void raiseEventSuppresion() {
        ++this.suppressEvents;
        if (this.suppressEvents > 10) {
            log.warn("suppress_events=" + this.suppressEvents);
        }
    }

    public boolean lowerEventSuppresionAndTest() {
        --this.suppressEvents;
        if (!$assertionsDisabled && this.suppressEvents < 0) {
            throw new AssertionError();
        }
        return this.suppressEvents == 0;
    }

    protected static VerseRange toVerseRange(Object base) throws ClassCastException {
        if (!$assertionsDisabled && base == null) {
            throw new AssertionError();
        }
        if (base instanceof VerseRange) {
            return (VerseRange)base;
        }
        if (base instanceof Verse) {
            return new VerseRange((Verse)base);
        }
        throw new ClassCastException(Msg.ABSTRACT_CAST.toString());
    }

    protected void writeObjectSupport(ObjectOutputStream out) throws IOException {
        int bitwise_size = BibleInfo.versesInBible();
        int ranged_size = 8 * this.countRanges(RestrictionType.NONE);
        int distinct_size = 4 * this.countVerses();
        if (bitwise_size <= ranged_size && bitwise_size <= distinct_size) {
            out.writeInt(0);
            BitSet store = new BitSet(BibleInfo.versesInBible());
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                store.set(verse.getOrdinal() - 1);
            }
            out.writeObject(store);
        } else if (distinct_size <= ranged_size) {
            out.writeInt(1);
            out.writeInt(this.countVerses());
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                out.writeInt(verse.getOrdinal());
            }
        } else {
            out.writeInt(2);
            out.writeInt(this.countRanges(RestrictionType.NONE));
            Iterator it = this.rangeIterator(RestrictionType.NONE);
            while (it.hasNext()) {
                VerseRange range = (VerseRange)it.next();
                out.writeInt(range.getStart().getOrdinal());
                out.writeInt(range.getVerseCount());
            }
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.listeners = new ArrayList();
        this.originalName = null;
        this.parent = null;
        this.skipNormalization = 0;
        this.suppressEvents = 0;
        is.defaultReadObject();
    }

    protected void readObjectSupport(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        try {
            int type = is.readInt();
            switch (type) {
                case 0: {
                    BitSet store = (BitSet)is.readObject();
                    for (int i = 0; i < BibleInfo.versesInBible(); ++i) {
                        if (!store.get(i)) continue;
                        this.add(new Verse(i + 1));
                    }
                    break;
                }
                case 1: {
                    int verses = is.readInt();
                    for (int i = 0; i < verses; ++i) {
                        int ord = is.readInt();
                        this.add(new Verse(ord));
                    }
                    break;
                }
                case 2: {
                    int ranges = is.readInt();
                    for (int i = 0; i < ranges; ++i) {
                        int ord = is.readInt();
                        int count = is.readInt();
                        this.add(RestrictionType.NONE.toRange(new Verse(ord), count));
                    }
                    break;
                }
                default: {
                    throw new ClassCastException(Msg.ABSTRACT_CAST.toString());
                }
            }
        }
        catch (NoSuchVerseException ex) {
            throw new IOException(ex.getMessage());
        }
        this.lowerEventSuppresionAndTest();
        this.lowerNormalizeProtection();
    }

    static {
        $assertionsDisabled = !AbstractPassage.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)AbstractPassage.class);
    }

    protected static final class VerseRangeIterator
    implements Iterator {
        private Iterator it;
        private VerseRange next_range;
        private Verse next_verse;
        private RestrictionType restrict;

        protected VerseRangeIterator(Iterator it, RestrictionType restrict) {
            this.it = it;
            this.restrict = restrict;
            if (it.hasNext()) {
                this.next_verse = (Verse)it.next();
            }
            this.calculateNext();
        }

        public boolean hasNext() {
            return this.next_range != null;
        }

        public Object next() throws NoSuchElementException {
            VerseRange retcode = this.next_range;
            if (retcode == null) {
                throw new NoSuchElementException();
            }
            this.calculateNext();
            return retcode;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private void calculateNext() {
            if (this.next_verse == null) {
                this.next_range = null;
                return;
            }
            Verse start = this.next_verse;
            Verse end = this.next_verse;
            while (true) {
                if (!this.it.hasNext()) {
                    this.next_verse = null;
                    break;
                }
                this.next_verse = (Verse)this.it.next();
                if (!end.adjacentTo(this.next_verse) || !this.restrict.isSameScope(end, this.next_verse)) break;
                end = this.next_verse;
            }
            this.next_range = new VerseRange(start, end);
        }
    }
}

