/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.IOException;
import java.net.URL;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;

public final class IndexDownloader {
    private static final String TEMP_PREFIX = "jsword-index";
    private static final String TEMP_SUFFIX = "dat";

    private IndexDownloader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadIndex(Book book, Installer installer) throws IOException, InstallException, BookException {
        URL tempDownload = NetUtil.getTemporaryURL((String)TEMP_PREFIX, (String)TEMP_SUFFIX);
        try {
            installer.downloadSearchIndex(book, tempDownload);
            IndexManager idxman = IndexManagerFactory.getIndexManager();
            idxman.installDownloadedIndex(book, tempDownload);
        }
        finally {
            if (tempDownload != null) {
                NetUtil.delete((URL)tempDownload);
            }
        }
    }
}

