/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.display.textpane;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JTextPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.TransformerException;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.URLEvent;
import org.crosswire.bibledesktop.display.URLEventListener;
import org.crosswire.bibledesktop.display.textpane.Msg;
import org.crosswire.common.swing.AntiAliasedTextPane;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.util.ConverterFactory;
import org.xml.sax.SAXException;

public class TextPaneBookDataDisplay
implements BookDataDisplay,
HyperlinkListener {
    private static final String HYPERLINK_STYLE = "Hyperlink";
    private static final String DOUBLE_SLASH = "//";
    private static final String SCROLL_TO_URL = "scrolling to: {0}";
    private static final String RELATIVE_URL_PROTOCOL = "";
    protected static final Logger log = Logger.getLogger((Class)TextPaneBookDataDisplay.class);
    private Book book;
    private Key key;
    private Converter converter;
    private JTextPane txtView;
    private Style style;
    private int lastStart;
    private int lastLength;
    private StyledDocument styledDoc;
    private EventListenerList listenerList = new EventListenerList();

    public TextPaneBookDataDisplay() {
        this.converter = ConverterFactory.getConverter();
        this.txtView = new AntiAliasedTextPane();
        this.txtView.setEditable(false);
        this.txtView.setEditorKit(new HTMLEditorKit());
        this.txtView.addHyperlinkListener(this);
        this.style = this.txtView.addStyle(HYPERLINK_STYLE, null);
        this.styledDoc = this.txtView.getStyledDocument();
        this.lastStart = -1;
        this.lastLength = -1;
    }

    public void setBookData(Book book, Key key) {
        this.book = book;
        this.key = key;
        this.refresh();
    }

    public void refresh() {
        if (this.book == null || this.key == null) {
            this.txtView.setText(RELATIVE_URL_PROTOCOL);
            return;
        }
        BookMetaData bmd = this.book.getBookMetaData();
        if (bmd == null) {
            this.txtView.setText(RELATIVE_URL_PROTOCOL);
            return;
        }
        boolean direction = bmd.isLeftToRight();
        this.txtView.applyComponentOrientation(direction ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
        try {
            URL loc;
            BookData bdata = this.book.getData(this.key);
            if (bdata == null) {
                this.txtView.setText(RELATIVE_URL_PROTOCOL);
                return;
            }
            SAXEventProvider osissep = bdata.getSAXEventProvider();
            TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)this.converter.convert(osissep);
            if (bmd.getBookCategory() == BookCategory.BIBLE) {
                XSLTProperty.setProperties(htmlsep);
            }
            if ((loc = bmd.getLocation()) != null) {
                htmlsep.setParameter("baseURL", (Object)loc.toExternalForm());
            }
            htmlsep.setParameter("direction", (Object)(direction ? "ltr" : "rtl"));
            String text = XMLUtil.writeToString((SAXEventProvider)htmlsep);
            this.txtView.setText(text);
            this.txtView.select(0, 0);
        }
        catch (SAXException e) {
            Reporter.informUser((Object)this, (Throwable)e);
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
        }
        catch (TransformerException e) {
            Reporter.informUser((Object)this, (Throwable)e);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent ev) {
        try {
            HyperlinkEvent.EventType type = ev.getEventType();
            JTextPane pane = (JTextPane)ev.getSource();
            String[] parts = this.getParts(ev.getDescription());
            if (type == HyperlinkEvent.EventType.ACTIVATED) {
                String url = ev.getDescription();
                if (parts[1].charAt(0) == '#') {
                    log.debug(MessageFormat.format(SCROLL_TO_URL, url));
                    url = url.substring(1);
                    pane.scrollToReference(url);
                } else {
                    this.fireActivateURL(new URLEvent(this, parts[0], parts[1]));
                }
            } else {
                boolean isEnter = type == HyperlinkEvent.EventType.ENTERED;
                int start = this.lastStart;
                int length = this.lastLength;
                if (isEnter) {
                    Element textElement = ev.getSourceElement();
                    start = textElement.getStartOffset();
                    length = textElement.getEndOffset() - start;
                    this.lastStart = start;
                    this.lastLength = length;
                }
                StyleConstants.setUnderline(this.style, isEnter);
                this.styledDoc.setCharacterAttributes(start, length, this.style, false);
                if (isEnter) {
                    this.fireEnterURL(new URLEvent(this, parts[0], parts[1]));
                } else {
                    this.fireLeaveURL(new URLEvent(this, parts[0], parts[1]));
                }
            }
        }
        catch (MalformedURLException ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    private String[] getParts(String reference) throws MalformedURLException {
        String protocol = RELATIVE_URL_PROTOCOL;
        String data = reference;
        int match = data.indexOf(58);
        if (match == -1) {
            if (data.charAt(0) != '#') {
                throw new MalformedURLException(Msg.BAD_PROTOCOL_URL.toString(data));
            }
        } else {
            protocol = data.substring(0, match);
            data = data.substring(match + 1);
        }
        if (data.startsWith(DOUBLE_SLASH)) {
            data = data.substring(2);
        }
        return new String[]{protocol, data};
    }

    public Component getComponent() {
        return this.txtView;
    }

    public void copy() {
        this.txtView.copy();
    }

    public synchronized void addURLEventListener(URLEventListener listener) {
        this.listenerList.add(URLEventListener.class, listener);
    }

    public synchronized void removeURLEventListener(URLEventListener listener) {
        this.listenerList.remove(URLEventListener.class, listener);
    }

    public void fireActivateURL(URLEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$bibledesktop$display$URLEventListener == null ? TextPaneBookDataDisplay.class$("org.crosswire.bibledesktop.display.URLEventListener") : class$org$crosswire$bibledesktop$display$URLEventListener)) continue;
            ((URLEventListener)listeners[i + 1]).activateURL(e);
        }
    }

    public void fireEnterURL(URLEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$bibledesktop$display$URLEventListener == null ? TextPaneBookDataDisplay.class$("org.crosswire.bibledesktop.display.URLEventListener") : class$org$crosswire$bibledesktop$display$URLEventListener)) continue;
            ((URLEventListener)listeners[i + 1]).enterURL(e);
        }
    }

    public void fireLeaveURL(URLEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$bibledesktop$display$URLEventListener == null ? TextPaneBookDataDisplay.class$("org.crosswire.bibledesktop.display.URLEventListener") : class$org$crosswire$bibledesktop$display$URLEventListener)) continue;
            ((URLEventListener)listeners[i + 1]).leaveURL(e);
        }
    }

    public void removeMouseListener(MouseListener li) {
        this.txtView.removeMouseListener(li);
    }

    public void addMouseListener(MouseListener li) {
        this.txtView.addMouseListener(li);
    }

    public Key getKey() {
        return this.key;
    }

    public Book getBook() {
        return this.book;
    }
}

