/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.crosswire.common.progress.swing.Msg;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Logger;

public class JobsProgressBar
extends JPanel
implements WorkListener {
    protected Map jobs = new HashMap();
    private List positions = new ArrayList();
    private Font font;
    private static final Logger log = Logger.getLogger((Class)JobsProgressBar.class);
    private static final long serialVersionUID = 3257563988660663606L;

    public JobsProgressBar(boolean small) {
        if (small) {
            this.font = new Font("SansSerif", 0, 10);
        }
        JobManager.addWorkListener((WorkListener)this);
        Set current = JobManager.getJobs();
        Iterator it = current.iterator();
        while (it.hasNext()) {
            Job job = (Job)it.next();
            this.addJob(job);
        }
        this.setLayout(new GridLayout(1, 0, 2, 0));
    }

    public synchronized void workProgressed(final WorkEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Job job = ev.getJob();
                if (!JobsProgressBar.this.jobs.containsKey(job)) {
                    JobsProgressBar.this.addJob(job);
                }
                JobsProgressBar.this.updateJob(job);
                if (job.isFinished()) {
                    JobsProgressBar.this.removeJob(job);
                }
            }
        });
    }

    public void workStateChanged(WorkEvent ev) {
        Job job = (Job)ev.getSource();
        JobData jobdata = (JobData)this.jobs.get(job);
        jobdata.workStateChanged(ev);
    }

    protected synchronized void addJob(Job job) {
        job.addWorkListener((WorkListener)this);
        int i = this.findEmptyPosition();
        log.debug("adding job to panel at " + i + ": " + job.getJobDescription());
        JProgressBar progress = new JProgressBar();
        progress.setStringPainted(true);
        progress.setToolTipText(job.getJobDescription());
        progress.setBorder(null);
        progress.setBackground(this.getBackground());
        progress.setForeground(this.getForeground());
        if (this.font != null) {
            progress.setFont(this.font);
        }
        JobData jobdata = new JobData(job, i, progress);
        this.jobs.put(job, jobdata);
        if (i >= this.positions.size()) {
            this.positions.add(jobdata);
        } else {
            this.positions.set(i, jobdata);
        }
        this.add(jobdata.getComponent(), i);
        GuiUtil.refresh(this);
    }

    protected synchronized void updateJob(Job job) {
        JobData jobdata = (JobData)this.jobs.get(job);
        int percent = job.getPercent();
        jobdata.getProgress().setString(job.getStateDescription() + ": (" + percent + "%)");
        jobdata.getProgress().setValue(percent);
    }

    protected synchronized void removeJob(Job job) {
        job.removeWorkListener((WorkListener)this);
        JobData jobdata = (JobData)this.jobs.get(job);
        this.positions.set(jobdata.getIndex(), null);
        this.jobs.remove(job);
        log.debug("removing job from panel: " + jobdata.getJob().getJobDescription());
        this.remove(jobdata.getComponent());
        GuiUtil.refresh(this);
        jobdata.invalidate();
    }

    private int findEmptyPosition() {
        int i;
        for (i = 0; i < this.positions.size() && this.positions.get(i) != null; ++i) {
        }
        return i;
    }

    private static class JobData
    implements WorkListener {
        private Job job;
        private int index;
        private JProgressBar progress;
        private Component comp;
        private JButton cancelButton;

        JobData(Job job, int index, JProgressBar progress) {
            this.job = job;
            this.index = index;
            this.progress = progress;
            this.comp = this.decorateProgressBar();
        }

        void invalidate() {
            this.job = null;
            this.progress = null;
            this.index = -1;
        }

        Job getJob() {
            return this.job;
        }

        JProgressBar getProgress() {
            return this.progress;
        }

        public Component getComponent() {
            return this.comp;
        }

        public JButton getCancelButton() {
            if (this.cancelButton == null) {
                this.cancelButton = this.createCancelButton();
            }
            return this.cancelButton;
        }

        int getIndex() {
            return this.index;
        }

        public void workStateChanged(WorkEvent evt) {
            if (this.cancelButton != null) {
                this.cancelButton.setEnabled(this.job.isInterruptable());
            }
        }

        public void workProgressed(WorkEvent ev) {
        }

        private JButton createCancelButton() {
            ImageIcon stop = GuiUtil.getIcon("toolbarButtonGraphics/general/Stop16.gif");
            this.cancelButton = new JButton(stop);
            this.cancelButton.setContentAreaFilled(false);
            this.cancelButton.setMargin(new Insets(0, 0, 0, 0));
            this.cancelButton.setBorderPainted(false);
            this.cancelButton.setRolloverEnabled(true);
            this.cancelButton.setToolTipText(Msg.CANCEL.toString());
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    JobData.this.getJob().interrupt();
                }
            });
            return this.cancelButton;
        }

        private Component decorateProgressBar() {
            if (!this.job.isInterruptable()) {
                return this.progress;
            }
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 1;
            gbc.fill = 0;
            panel.add((Component)this.createCancelButton(), gbc);
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            panel.add((Component)this.progress, gbc);
            return panel;
        }
    }
}

