/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.BitwisePassage;
import org.crosswire.jsword.passage.DistinctPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RangedPassage;
import org.crosswire.jsword.passage.ReadOnlyPassage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.RocketPassage;
import org.crosswire.jsword.passage.SynchronizedPassage;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;

public final class PassageKeyFactory
implements KeyFactory {
    public static final int SPEED = 0;
    public static final int WRITE_SPEED = 1;
    public static final int SIZE = 2;
    public static final int MIX = 3;
    public static final int TALLY = 4;
    private static KeyFactory keyf;
    private static Passage whole;
    private static int defaultType;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PassageKeyFactory() {
    }

    public static KeyFactory instance() {
        return keyf;
    }

    public Key createEmptyKeyList() {
        return this.createPassage();
    }

    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (Exception e) {
            return this.createEmptyKeyList();
        }
    }

    public Key getKey(String name) throws NoSuchKeyException {
        return this.createPassage(name);
    }

    public Key getGlobalKeyList() {
        try {
            if (whole == null) {
                whole = new ReadOnlyPassage(this.createPassage("Gen 1:1-Rev 22:21"), true);
            }
            return whole;
        }
        catch (Exception ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return this.createPassage();
        }
    }

    protected Passage createPassage() {
        return this.createPassage(defaultType);
    }

    protected Passage createPassage(String name) throws NoSuchVerseException {
        if (name == null) {
            this.createPassage(defaultType);
        }
        return this.createPassage(defaultType, name);
    }

    protected Passage createPassage(int type) {
        switch (type) {
            case 3: {
                return new RangedPassage();
            }
            case 1: {
                return new BitwisePassage();
            }
            case 0: {
                return new RocketPassage();
            }
            case 2: {
                return new DistinctPassage();
            }
            case 4: {
                return new PassageTally();
            }
        }
        throw new IllegalArgumentException(Integer.toString(type));
    }

    protected Passage createPassage(int type, String name) throws NoSuchVerseException {
        if (name == null) {
            this.createPassage(type);
        }
        switch (type) {
            case 3: {
                return new RangedPassage(name);
            }
            case 1: {
                return new BitwisePassage(name);
            }
            case 0: {
                return new RocketPassage(name);
            }
            case 2: {
                return new DistinctPassage(name);
            }
            case 4: {
                return new PassageTally(name);
            }
        }
        throw new IllegalArgumentException(Integer.toString(type));
    }

    public static void setDefaultPassage(int defaultType) {
        PassageKeyFactory.defaultType = defaultType;
    }

    public static int getDefaultPassage() {
        return defaultType;
    }

    public static Passage getSynchronizedPassage(Passage ref) {
        return new SynchronizedPassage(ref);
    }

    public static Passage getReadOnlyPassage(Passage ref, boolean ignore) {
        return new ReadOnlyPassage(ref, ignore);
    }

    public static byte[] toBinaryRepresentation(Passage ref) {
        int verses = ref.countVerses();
        int ranges = ref.countRanges(RestrictionType.NONE);
        int bitwise_size = BibleInfo.versesInBible() / 8;
        int ranged_size = ranges * 4 + 1;
        int distinct_size = verses * 2 + 1;
        if (bitwise_size <= ranged_size && bitwise_size <= distinct_size) {
            int array_size = PassageKeyFactory.binarySize(3) + BibleInfo.versesInBible() / 8 + 1;
            byte[] buffer = new byte[array_size];
            int index = 0;
            index += PassageKeyFactory.toBinary(buffer, index, 0, 3);
            Iterator it = ref.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                int ord = verse.getOrdinal();
                int idx0 = ord / 8 + index;
                int bit = ord % 8 - 1;
                int n = idx0;
                buffer[n] = (byte)(buffer[n] | 1 << bit);
            }
            return buffer;
        }
        if (distinct_size <= ranged_size) {
            int array_size = PassageKeyFactory.binarySize(3) + PassageKeyFactory.binarySize(BibleInfo.versesInBible()) + verses * PassageKeyFactory.binarySize(BibleInfo.versesInBible());
            byte[] buffer = new byte[array_size];
            int index = 0;
            index += PassageKeyFactory.toBinary(buffer, index, 1, 3);
            index += PassageKeyFactory.toBinary(buffer, index, verses, BibleInfo.versesInBible());
            Iterator it = ref.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                int ord = verse.getOrdinal();
                index += PassageKeyFactory.toBinary(buffer, index, ord, BibleInfo.versesInBible());
            }
            return buffer;
        }
        int array_size = PassageKeyFactory.binarySize(3) + PassageKeyFactory.binarySize(BibleInfo.versesInBible() / 2) + 2 * ranges * PassageKeyFactory.binarySize(BibleInfo.versesInBible());
        byte[] buffer = new byte[array_size];
        int index = 0;
        index += PassageKeyFactory.toBinary(buffer, index, 2, 3);
        index += PassageKeyFactory.toBinary(buffer, index, ranges, BibleInfo.versesInBible() / 2);
        Iterator it = ref.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            VerseRange range = (VerseRange)it.next();
            index += PassageKeyFactory.toBinary(buffer, index, range.getStart().getOrdinal(), BibleInfo.versesInBible());
            index += PassageKeyFactory.toBinary(buffer, index, range.getVerseCount(), BibleInfo.versesInBible());
        }
        return buffer;
    }

    public static Passage fromBinaryRepresentation(byte[] buffer) throws NoSuchVerseException {
        Passage ref = (Passage)keyf.createEmptyKeyList();
        AbstractPassage aref = null;
        if (ref instanceof AbstractPassage) {
            aref = (AbstractPassage)ref;
            aref.raiseEventSuppresion();
            aref.raiseNormalizeProtection();
        }
        int[] index = new int[]{0};
        int type = PassageKeyFactory.fromBinary(buffer, index, 3);
        switch (type) {
            case 0: {
                for (int ord = 1; ord <= BibleInfo.versesInBible(); ++ord) {
                    int idx0 = ord / 8 + index[0];
                    int bit = ord % 8 - 1;
                    if ((buffer[idx0] & 1 << bit) == 0) continue;
                    ref.add(new Verse(ord));
                }
                break;
            }
            case 1: {
                int verses = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible());
                for (int i = 0; i < verses; ++i) {
                    int ord = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible());
                    ref.add(new Verse(ord));
                }
                break;
            }
            case 2: {
                int ranges = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible() / 2);
                for (int i = 0; i < ranges; ++i) {
                    int ord = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible());
                    int len = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible());
                    ref.add(RestrictionType.NONE.toRange(new Verse(ord), len));
                }
                break;
            }
            default: {
                throw new NoSuchVerseException(Msg.PASSAGE_UNKNOWN);
            }
        }
        if (aref != null) {
            aref.lowerEventSuppresionAndTest();
            aref.lowerNormalizeProtection();
        }
        return ref;
    }

    public static Passage readPassage(Reader in) throws IOException, NoSuchVerseException {
        Passage ref = (Passage)keyf.createEmptyKeyList();
        ref.readDescription(in);
        return ref;
    }

    protected static int binarySize(int max) {
        if (max < 256) {
            return 1;
        }
        if (max < 65536) {
            return 2;
        }
        if (max < 0x1000000) {
            return 3;
        }
        return 4;
    }

    protected static int toBinary(byte[] buffer, int index, int number, int max) {
        if (!$assertionsDisabled && number < 0) {
            throw new AssertionError((Object)("No -ve output " + number));
        }
        if (!$assertionsDisabled && number > max) {
            throw new AssertionError((Object)("number " + number + " > max " + max));
        }
        if (max < 256) {
            buffer[index] = (byte)number;
            return 1;
        }
        if (max < 65536) {
            buffer[index + 0] = (byte)(number >>> 8);
            buffer[index + 1] = (byte)(number >>> 0);
            return 2;
        }
        if (max < 0x1000000) {
            buffer[index + 0] = (byte)(number >>> 16);
            buffer[index + 1] = (byte)(number >>> 8);
            buffer[index + 2] = (byte)(number >>> 0);
            return 3;
        }
        buffer[index + 0] = (byte)(number >>> 24);
        buffer[index + 1] = (byte)(number >>> 16);
        buffer[index + 2] = (byte)(number >>> 8);
        buffer[index + 3] = (byte)(number >>> 0);
        return 4;
    }

    protected static int fromBinary(byte[] buffer, int[] index, int max) {
        int n = index[0];
        index[0] = n + 1;
        int b0 = buffer[n] & 0xFF;
        if (max < 256) {
            return b0;
        }
        int n2 = index[0];
        index[0] = n2 + 1;
        int b1 = buffer[n2] & 0xFF;
        if (max < 65536) {
            return (b0 << 8) + (b1 << 0);
        }
        int n3 = index[0];
        index[0] = n3 + 1;
        int b2 = buffer[n3] & 0xFF;
        if (max < 0x1000000) {
            return (b0 << 16) + (b1 << 8) + (b2 << 0);
        }
        int n4 = index[0];
        index[0] = n4 + 1;
        int b3 = buffer[n4] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + (b3 << 0);
    }

    static {
        $assertionsDisabled = !PassageKeyFactory.class.desiredAssertionStatus();
        keyf = new PassageKeyFactory();
        defaultType = 0;
    }
}

