/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.Serializable;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.BlockType;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.GZIPBackend;
import org.crosswire.jsword.book.sword.LZSSBackend;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;

public abstract class CompressionType
implements Serializable {
    public static final CompressionType COMPRESSION_ZIP = new CompressionType("ZIP"){
        private static final long serialVersionUID = 3977014063492642096L;

        public boolean isSupported() {
            return true;
        }

        protected AbstractBackend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            BlockType blockType = BlockType.fromString(sbmd.getProperty(ConfigEntryType.BLOCK_TYPE));
            return new GZIPBackend(sbmd, rootPath, blockType);
        }
    };
    public static final CompressionType COMPRESSION_LZSS = new CompressionType("LZSS"){
        private static final long serialVersionUID = 3257847692691517494L;

        public boolean isSupported() {
            return false;
        }

        protected AbstractBackend getBackend(SwordBookMetaData sbmd, File rootPath) throws BookException {
            return new LZSSBackend(sbmd, rootPath);
        }
    };
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final CompressionType[] VALUES;

    public CompressionType(String name) {
        this.name = name;
    }

    abstract boolean isSupported();

    abstract AbstractBackend getBackend(SwordBookMetaData var1, File var2) throws BookException;

    public static CompressionType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            CompressionType obj = VALUES[i];
            if (!obj.name.equalsIgnoreCase(name)) continue;
            return obj;
        }
        throw new ClassCastException(Msg.UNDEFINED_DATATYPE.toString(name));
    }

    public static CompressionType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        VALUES = new CompressionType[]{COMPRESSION_ZIP, COMPRESSION_LZSS};
    }
}

