/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.readings;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.crosswire.jsword.book.readings.Msg;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;

public class ReadingsKey
extends DefaultLeafKeyList {
    private Date date;
    private static final DateFormat NAME_DF = new SimpleDateFormat("d MMMM");
    private static final DateFormat OSIS_DF = new SimpleDateFormat("d.MMMM");
    private static final MessageFormat KEY_FORMAT;

    protected ReadingsKey(String text, String osisName, Key parent) throws NoSuchKeyException {
        super(text, osisName, parent);
        try {
            this.date = NAME_DF.parse(text);
        }
        catch (ParseException ex) {
            throw new NoSuchKeyException(Msg.PARSE_FAIL, ex, new Object[]{text});
        }
    }

    protected ReadingsKey(Date date) {
        super(NAME_DF.format(date), OSIS_DF.format(date));
        this.date = date;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ReadingsKey that = (ReadingsKey)obj;
        return this.date.equals(that.date);
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    public int compareTo(Object obj) {
        ReadingsKey that = (ReadingsKey)obj;
        return this.date.compareTo(that.date);
    }

    public Object clone() {
        return super.clone();
    }

    public static String external2internal(Calendar externalKey) {
        Object[] objs = new Object[]{new Integer(1 + externalKey.get(2)), new Integer(externalKey.get(5))};
        return KEY_FORMAT.format(objs);
    }

    static {
        NAME_DF.setLenient(true);
        KEY_FORMAT = new MessageFormat("{0,number,00}.{1,number,00}");
    }
}

