/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompositeIcon
implements Icon {
    private Icon icon1;
    private Icon icon2;
    private int position;
    private int horizontalOrientation;
    private int verticalOrientation;

    public CompositeIcon(Icon icon1, Icon icon2) {
        this(icon1, icon2, 1);
    }

    public CompositeIcon(Icon icon1, Icon icon2, int position) {
        this(icon1, icon2, position, 0, 0);
    }

    public CompositeIcon(Icon icon1, Icon icon2, int position, int horizontalOrientation, int verticalOrientation) {
        this.icon1 = icon1;
        this.icon2 = icon2;
        this.position = position;
        this.horizontalOrientation = horizontalOrientation;
        this.verticalOrientation = verticalOrientation;
    }

    public int getIconHeight() {
        if (this.position == 1 || this.position == 3) {
            return this.icon1.getIconHeight() + this.icon2.getIconHeight();
        }
        return Math.max(this.icon1.getIconHeight(), this.icon2.getIconHeight());
    }

    public int getIconWidth() {
        if (this.position == 2 || this.position == 4) {
            return this.icon1.getIconWidth() + this.icon2.getIconWidth();
        }
        return Math.max(this.icon1.getIconWidth(), this.icon2.getIconWidth());
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        if (this.position == 2 || this.position == 4) {
            Icon rightIcon;
            Icon leftIcon;
            if (this.position == 2) {
                leftIcon = this.icon1;
                rightIcon = this.icon2;
            } else {
                leftIcon = this.icon2;
                rightIcon = this.icon1;
            }
            this.paintIcon(c, g, leftIcon, x, y, width, height, 2, this.verticalOrientation);
            this.paintIcon(c, g, rightIcon, x + leftIcon.getIconWidth(), y, width, height, 2, this.verticalOrientation);
        } else if (this.position == 1 || this.position == 3) {
            Icon bottomIcon;
            Icon topIcon;
            if (this.position == 1) {
                topIcon = this.icon1;
                bottomIcon = this.icon2;
            } else {
                topIcon = this.icon2;
                bottomIcon = this.icon1;
            }
            this.paintIcon(c, g, topIcon, x, y, width, height, this.horizontalOrientation, 1);
            this.paintIcon(c, g, bottomIcon, x, y + topIcon.getIconHeight(), width, height, this.horizontalOrientation, 1);
        } else {
            this.paintIcon(c, g, this.icon1, x, y, width, height, this.horizontalOrientation, this.verticalOrientation);
            this.paintIcon(c, g, this.icon2, x, y, width, height, this.horizontalOrientation, this.verticalOrientation);
        }
    }

    private void paintIcon(Component c, Graphics g, Icon icon, int x, int y, int width, int height, int hOrientation, int vOrientation) {
        int yIcon;
        int xIcon;
        switch (hOrientation) {
            case 2: {
                xIcon = x;
                break;
            }
            case 4: {
                xIcon = x + width - icon.getIconWidth();
                break;
            }
            default: {
                xIcon = x + (width - icon.getIconWidth()) / 2;
            }
        }
        switch (vOrientation) {
            case 1: {
                yIcon = y;
                break;
            }
            case 3: {
                yIcon = y + height - icon.getIconHeight();
                break;
            }
            default: {
                yIcon = y + (height - icon.getIconHeight()) / 2;
            }
        }
        icon.paintIcon(c, g, xIcon, yIcon);
    }
}

