/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import javax.swing.ComboBoxModel;
import org.crosswire.bibledesktop.book.BooksListModel;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.Defaults;

public class BooksComboBoxModel
extends BooksListModel
implements ComboBoxModel {
    protected transient Book current;
    private static final long serialVersionUID = 3906362740397388593L;

    public BooksComboBoxModel() {
        this(null);
    }

    public BooksComboBoxModel(BookFilter filter) {
        super(filter);
        this.postCacheData();
        if (this.getSize() > 0) {
            this.current = (Book)this.getElementAt(0);
            this.tryInitialSelection(Defaults.getCommentary());
            this.tryInitialSelection(Defaults.getDictionary());
            this.tryInitialSelection(Defaults.getBible());
        }
    }

    private void tryInitialSelection(Book book) {
        int i;
        if (book != null && (i = this.books.indexOf(book)) != -1) {
            this.current = book;
        }
    }

    public void setSelectedItem(Object selected) {
        this.current = (Book)selected;
        Defaults.setCurrentBook((Book)this.current);
        this.fireContentsChanged(this, -1, -1);
    }

    public Object getSelectedItem() {
        return this.current;
    }

    public Book getSelectedBook() {
        return this.current;
    }

    protected final synchronized void postCacheData() {
        boolean found = false;
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            if (this.getElementAt(i) != this.current) continue;
            found = true;
            break;
        }
        if (!found) {
            this.current = this.getSize() > 0 ? (Book)this.getElementAt(0) : null;
        }
    }
}

