/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.crosswire.common.config.AbstractReflectedChoice;
import org.crosswire.common.config.Msg;
import org.crosswire.common.config.MultipleChoice;
import org.crosswire.common.config.StartupException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.jdom.Element;

public class IntOptionsChoice
extends AbstractReflectedChoice
implements MultipleChoice {
    private String[] options;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init(Element option, ResourceBundle configResources) throws StartupException {
        if (!$assertionsDisabled && configResources == null) {
            throw new AssertionError();
        }
        super.init(option, configResources);
        String prefix = option.getAttributeValue("key") + ".alternative.";
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = option.getChildren("alternative").iterator();
        while (iter.hasNext()) {
            Element alternative = (Element)iter.next();
            int number = Integer.parseInt(alternative.getAttributeValue("number"));
            String name = configResources.getString(prefix + number);
            list.add(number, name);
        }
        this.options = list.toArray(new String[list.size()]);
    }

    public String[] getOptions() {
        String[] copy = new String[this.options.length];
        System.arraycopy(this.options, 0, copy, 0, this.options.length);
        return copy;
    }

    public Class getConversionClass() {
        return Integer.TYPE;
    }

    public String convertToString(Object orig) {
        return this.options[(Integer)orig];
    }

    public Object convertToObject(String orig) {
        try {
            return new Integer(orig);
        }
        catch (NumberFormatException ex) {
            for (int i = 0; i < this.options.length; ++i) {
                if (!this.options[i].equalsIgnoreCase(orig)) continue;
                return new Integer(i);
            }
            Reporter.informUser((Object)this, (MsgBase)Msg.IGNORE, new Object[]{orig});
            return this.options[0];
        }
    }

    static {
        $assertionsDisabled = !IntOptionsChoice.class.desiredAssertionStatus();
    }
}

