/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.passage.RangeListModel;
import org.crosswire.bibledesktop.passage.WholeBibleTreeModel;
import org.crosswire.bibledesktop.passage.WholeBibleTreeNode;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageEvent;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.PassageListener;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.VerseRange;

public class PassageSelectionPane
extends JPanel {
    private static final String BIBLE_TREE = "BibleTree";
    private static final String ADD = "AddVerse";
    private static final String DELETE = "DeleteVerse";
    private static final String SELECTED_VERSES = "SelectedVerses";
    private static final String VERSES = "Verses";
    private static final String DONE = "Done";
    protected transient KeyFactory keyf = PassageKeyFactory.instance();
    protected boolean bailout;
    private boolean changing;
    private Passage ref;
    private transient ActionFactory actions;
    private transient Icon icoGood = GuiUtil.getIcon((String)"toolbarButtonGraphics/general/About24.gif");
    private transient Icon icoBad = GuiUtil.getIcon((String)"toolbarButtonGraphics/general/Stop24.gif");
    private JTree treAll;
    private JList lstSel;
    private RangeListModel model;
    private JTextField txtDisplay;
    private JLabel lblMessage;
    protected JDialog dlgMain;
    private static final long serialVersionUID = 3546920298944673072L;

    public PassageSelectionPane() {
        this.init();
    }

    private void init() {
        this.actions = new ActionFactory(PassageSelectionPane.class, (Object)this);
        JLabel lblAll = this.actions.createJLabel(BIBLE_TREE);
        JLabel lblSel = this.actions.createJLabel(SELECTED_VERSES);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.add((Component)lblAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add(this.createScrolledTree(lblAll), new GridBagConstraints(0, 1, 1, 4, 0.5, 0.0, 10, 1, new Insets(0, 10, 10, 2), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JButton(this.actions.getAction(DELETE)), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JButton(this.actions.getAction(ADD)), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblSel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.add(this.createScrolledList(lblSel), new GridBagConstraints(2, 1, 1, 4, 0.5, 0.0, 10, 1, new Insets(0, 2, 10, 10), 0, 0));
        this.add(this.createMessageLabel(), new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.add(this.createDisplayPanel(), new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
    }

    private Component createScrolledTree(JLabel label) {
        this.treAll = new JTree();
        this.treAll.setModel(new WholeBibleTreeModel());
        this.treAll.setShowsRootHandles(true);
        this.treAll.setRootVisible(false);
        this.treAll.putClientProperty("JTree.lineStyle", "Angled");
        this.treAll.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                PassageSelectionPane.this.treeSelected();
            }
        });
        label.setLabelFor(this.treAll);
        return new JScrollPane(this.treAll);
    }

    private Component createScrolledList(JLabel label) {
        this.model = new RangeListModel(RestrictionType.CHAPTER);
        this.lstSel = new JList(this.model);
        this.lstSel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                PassageSelectionPane.this.listSelected();
            }
        });
        label.setLabelFor(this.lstSel);
        return new JScrollPane(this.lstSel);
    }

    private Component createDisplayPanel() {
        this.txtDisplay = new JTextField();
        this.txtDisplay.getDocument().addDocumentListener(new CustomDocumentEvent());
        JLabel lblDisplay = this.actions.createJLabel(VERSES);
        lblDisplay.setLabelFor(this.txtDisplay);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.txtDisplay, "Center");
        panel.add((Component)lblDisplay, "West");
        return panel;
    }

    private Component createMessageLabel() {
        this.lblMessage = new JLabel();
        return this.lblMessage;
    }

    protected void copyListToText() {
        if (this.changing) {
            return;
        }
        this.changing = true;
        this.txtDisplay.setText(this.ref.getName());
        this.updateMessageSummary();
        this.changing = false;
    }

    protected void copyTextToList() {
        if (this.changing) {
            return;
        }
        this.changing = true;
        String refstr = this.txtDisplay.getText();
        try {
            Passage temp = (Passage)this.keyf.getKey(refstr);
            this.ref.clear();
            this.ref.addAll((Key)temp);
            this.model.setPassage(this.ref);
            this.setValidPassage(true);
            this.updateMessageSummary();
        }
        catch (NoSuchKeyException ex) {
            this.setValidPassage(false);
            this.updateMessage(ex);
        }
        this.changing = false;
    }

    private void setValidPassage(boolean valid) {
        this.lstSel.setEnabled(valid);
        this.treAll.setEnabled(valid);
        this.actions.getAction(ADD).setEnabled(valid);
        this.actions.getAction(DELETE).setEnabled(valid);
    }

    private void updateMessage(NoSuchKeyException ex) {
        this.lblMessage.setText(Msg.ERROR.toString(ex.getMessage()));
        this.lblMessage.setIcon(this.icoBad);
    }

    private void updateMessageSummary() {
        this.lblMessage.setText(Msg.SUMMARY.toString(this.ref.getOverview()));
        this.lblMessage.setIcon(this.icoGood);
    }

    public String showInDialog(Component parent, String title, boolean modal, String refstr) {
        try {
            this.ref = (Passage)this.keyf.getKey(refstr);
            this.txtDisplay.setText(refstr);
            this.ref.addPassageListener((PassageListener)new CustomPassageListener());
            this.updateMessageSummary();
        }
        catch (NoSuchKeyException ex) {
            this.setValidPassage(false);
            this.updateMessage(ex);
        }
        this.treeSelected();
        this.listSelected();
        this.dlgMain = new JDialog(JOptionPane.getFrameForComponent(parent));
        JPanel pnlAction = new JPanel();
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.bailout = true;
        JButton btnGo = new JButton(this.actions.getAction(DONE));
        pnlAction.setLayout(new BorderLayout());
        pnlAction.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 20));
        pnlAction.add((Component)btnGo, "East");
        ActionListener closer = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PassageSelectionPane.this.dlgMain.dispose();
            }
        };
        this.dlgMain.getContentPane().setLayout(new BorderLayout());
        this.dlgMain.getContentPane().add((Component)this, "Center");
        this.dlgMain.getContentPane().add((Component)pnlAction, "South");
        this.dlgMain.getRootPane().setDefaultButton(btnGo);
        this.dlgMain.getRootPane().registerKeyboardAction(closer, esc, 2);
        this.dlgMain.setDefaultCloseOperation(2);
        this.dlgMain.setTitle(title);
        this.dlgMain.setModal(modal);
        GuiUtil.restrainedPack((Window)this.dlgMain, (float)0.5f, (float)0.75f);
        GuiUtil.centerWindow((Window)this.dlgMain);
        this.dlgMain.setVisible(true);
        if (this.bailout) {
            return null;
        }
        return this.txtDisplay.getText();
    }

    public void doAddVerse() {
        TreePath[] selected = this.treAll.getSelectionPaths();
        if (selected != null) {
            for (int i = 0; i < selected.length; ++i) {
                WholeBibleTreeNode node = (WholeBibleTreeNode)selected[i].getLastPathComponent();
                VerseRange range = node.getVerseRange();
                this.ref.add((Key)range);
            }
            this.model.setPassage(this.ref);
        }
    }

    public void doDeleteVerse() {
        Object[] selected = this.lstSel.getSelectedValues();
        if (selected != null) {
            for (int i = 0; i < selected.length; ++i) {
                VerseRange range = (VerseRange)selected[i];
                this.ref.remove((Key)range);
            }
            this.model.setPassage(this.ref);
        }
    }

    public void doDone() {
        this.bailout = false;
        this.dlgMain.dispose();
    }

    protected void treeSelected() {
        TreePath[] selected = this.treAll.getSelectionPaths();
        this.actions.getAction(ADD).setEnabled(selected != null && selected.length > 0);
    }

    protected void listSelected() {
        Object[] selected = this.lstSel.getSelectedValues();
        this.actions.getAction(DELETE).setEnabled(selected != null && selected.length > 0);
    }

    private class CustomPassageListener
    implements PassageListener {
        private CustomPassageListener() {
        }

        public void versesAdded(PassageEvent ev) {
            PassageSelectionPane.this.copyListToText();
        }

        public void versesRemoved(PassageEvent ev) {
            PassageSelectionPane.this.copyListToText();
        }

        public void versesChanged(PassageEvent ev) {
            PassageSelectionPane.this.copyListToText();
        }
    }

    private class CustomDocumentEvent
    implements DocumentListener {
        private CustomDocumentEvent() {
        }

        public void insertUpdate(DocumentEvent ev) {
            PassageSelectionPane.this.copyTextToList();
        }

        public void removeUpdate(DocumentEvent ev) {
            PassageSelectionPane.this.copyTextToList();
        }

        public void changedUpdate(DocumentEvent ev) {
            PassageSelectionPane.this.copyTextToList();
        }
    }
}

