/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;
import org.crosswire.bibledesktop.book.BibleComboBoxModel;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;

public class BibleComboBoxModelSet {
    private Verse verse = Verse.DEFAULT;
    protected JComboBox cboBook;
    protected JComboBox cboChapter;
    private JComboBox cboVerse;
    protected BibleComboBoxModel mdlBook = new BibleComboBoxModel(this, 0);
    protected BibleComboBoxModel mdlChapter = new BibleComboBoxModel(this, 1);
    protected BibleComboBoxModel mdlVerse = new BibleComboBoxModel(this, 2);
    protected EventListenerList listeners = new EventListenerList();
    private ItemListener cil = new CustomItemListener();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setBookComboBox(JComboBox cboBook) {
        this.cboBook = cboBook;
        cboBook.setModel(this.mdlBook);
        cboBook.addItemListener(this.cil);
    }

    public void setChapterComboBox(JComboBox cboChapter) {
        this.cboChapter = cboChapter;
        cboChapter.setModel(this.mdlChapter);
        cboChapter.setPrototypeDisplayValue(new Integer(999));
        cboChapter.addItemListener(this.cil);
    }

    public void setVerseComboBox(JComboBox cboVerse) {
        this.cboVerse = cboVerse;
        cboVerse.setModel(this.mdlVerse);
        this.cboChapter.setPrototypeDisplayValue(new Integer(999));
        cboVerse.addItemListener(this.cil);
    }

    public Verse getVerse() {
        return this.verse;
    }

    protected void setViewedVerse(Verse newverse) {
        this.setVerse(newverse);
    }

    public void setVerse(Verse newverse) {
        block6: {
            if (this.verse.equals((Object)newverse)) {
                return;
            }
            try {
                Verse oldverse = this.verse;
                this.verse = newverse;
                int bookval = newverse.getBook();
                String book = BibleInfo.getLongBookName((int)bookval);
                if (oldverse.getBook() != bookval || !this.cboBook.getSelectedItem().equals(book)) {
                    this.cboBook.setSelectedItem(book);
                }
                int chapterval = newverse.getChapter();
                Integer chapternum = new Integer(chapterval);
                if (oldverse.getChapter() != chapterval || !this.cboChapter.getSelectedItem().equals(chapternum)) {
                    this.cboChapter.setSelectedItem(chapternum);
                }
                int verseval = newverse.getVerse();
                Integer versenum = new Integer(verseval);
                if (oldverse.getVerse() != verseval || !this.cboVerse.getSelectedItem().equals(versenum)) {
                    this.cboVerse.setSelectedItem(versenum);
                }
                this.fireContentsChanged();
            }
            catch (NoSuchVerseException ex) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)ex);
            }
        }
    }

    public void addActionListener(ActionListener li) {
        this.listeners.add(ActionListener.class, li);
    }

    public void removeActionListener(ActionListener li) {
        this.listeners.remove(ActionListener.class, li);
    }

    protected void fireContentsChanged() {
        Object[] liarray = this.listeners.getListenerList();
        ActionEvent ev = null;
        for (int i = liarray.length - 2; i >= 0; i -= 2) {
            if (liarray[i] != (class$java$awt$event$ActionListener == null ? BibleComboBoxModelSet.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            if (ev == null) {
                ev = new ActionEvent(this, 1001, this.verse.getName());
            }
            ((ActionListener)liarray[i + 1]).actionPerformed(ev);
        }
    }

    static {
        $assertionsDisabled = !BibleComboBoxModelSet.class.desiredAssertionStatus();
    }

    private final class CustomItemListener
    implements ItemListener {
        private CustomItemListener() {
        }

        public void itemStateChanged(ItemEvent ev) {
            if (ev.getStateChange() == 1) {
                Object source = ev.getSource();
                if (source.equals(BibleComboBoxModelSet.this.cboBook)) {
                    BibleComboBoxModelSet.this.mdlChapter.fireContentsChanged(this, 0, BibleComboBoxModelSet.this.mdlChapter.getSize());
                }
                if (source.equals(BibleComboBoxModelSet.this.cboBook) || source.equals(BibleComboBoxModelSet.this.cboChapter)) {
                    BibleComboBoxModelSet.this.mdlVerse.fireContentsChanged(this, 0, BibleComboBoxModelSet.this.mdlVerse.getSize());
                }
            }
        }
    }
}

