/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.PassageUtil;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;

public final class VerseRange
implements Key {
    public static final String RANGE_ALLOWED_DELIMS = "-";
    public static final String RANGE_PREF_DELIM = "-";
    static final long serialVersionUID = 8307795549869653580L;
    private transient int verseCount;
    private transient Verse start;
    private transient Verse end;
    private transient Key parent;
    private transient String originalName;
    private static transient VerseRange whole;
    static final transient Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VerseRange() {
        this(Verse.DEFAULT);
    }

    public VerseRange(Verse start) {
        this(start, start);
    }

    public VerseRange(Verse start, Verse end) {
        this(null, start, end);
    }

    VerseRange(String original, Verse start, Verse end) {
        if (!$assertionsDisabled && start == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && end == null) {
            throw new AssertionError();
        }
        this.originalName = original;
        switch (start.compareTo(end)) {
            case -1: {
                this.start = start;
                this.end = end;
                this.verseCount = VerseRange.calcVerseCount(start, end);
                break;
            }
            case 0: {
                this.start = start;
                this.end = start;
                this.verseCount = 1;
                break;
            }
            case 1: {
                this.start = end;
                this.end = start;
                this.verseCount = VerseRange.calcVerseCount(this.start, this.end);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        this.verifyData();
    }

    public VerseRange(VerseRange a, VerseRange b) {
        this.start = Verse.min(a.getStart(), b.getStart());
        this.end = Verse.max(a.getEnd(), b.getEnd());
        this.verseCount = VerseRange.calcVerseCount(this.start, this.end);
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(Key base) {
        if (PassageUtil.isPersistentNaming() && this.originalName != null) {
            return this.originalName;
        }
        int start_book = this.start.getBook();
        int start_chapter = this.start.getChapter();
        int start_verse = this.start.getVerse();
        int end_book = this.end.getBook();
        int end_chapter = this.end.getChapter();
        int end_verse = this.end.getVerse();
        try {
            if (start_book != end_book) {
                if (this.isWholeBooks()) {
                    return BibleInfo.getBookName(start_book) + "-" + BibleInfo.getBookName(end_book);
                }
                if (this.isWholeChapters()) {
                    return BibleInfo.getBookName(start_book) + " " + start_chapter + "-" + BibleInfo.getBookName(end_book) + " " + end_chapter;
                }
                return this.start.getName(base) + "-" + this.end.getName(base);
            }
            if (this.isWholeBook()) {
                return BibleInfo.getBookName(start_book);
            }
            if (start_chapter != end_chapter) {
                if (this.isWholeChapters()) {
                    return BibleInfo.getBookName(start_book) + " " + start_chapter + "-" + end_chapter;
                }
                return this.start.getName(base) + "-" + end_chapter + ":" + end_verse;
            }
            if (this.isWholeChapter()) {
                return BibleInfo.getBookName(start_book) + " " + start_chapter;
            }
            if (start_verse != end_verse) {
                return this.start.getName(base) + "-" + end_verse;
            }
            return this.start.getName(base);
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public String getOsisRef() {
        try {
            int endChapter;
            int startBook = this.start.getBook();
            int endBook = this.end.getBook();
            if (startBook != endBook) {
                return this.start.getOsisRef() + "-" + this.end.getOsisRef();
            }
            if (this.isWholeBook()) {
                return BibleInfo.getOSISName(startBook);
            }
            int startChapter = this.start.getChapter();
            if (startChapter != (endChapter = this.end.getChapter())) {
                return this.start.getOsisRef() + "-" + this.end.getOsisRef();
            }
            if (this.isWholeChapter()) {
                return BibleInfo.getOSISName(startBook) + "." + startChapter;
            }
            if (this.start.getVerse() != this.end.getVerse()) {
                return this.start.getOsisRef() + "-" + this.end.getOsisRef();
            }
            return this.start.getOsisRef();
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
    }

    public String getOsisID() {
        try {
            if (this.isWholeBook()) {
                return BibleInfo.getOSISName(this.start.getBook());
            }
            if (this.isWholeChapter()) {
                return BibleInfo.getOSISName(this.start.getBook()) + "." + this.start.getChapter();
            }
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return "!Error!";
        }
        int startOrdinal = this.start.getOrdinal();
        int endOrdinal = this.end.getOrdinal();
        StringBuffer buf = new StringBuffer((endOrdinal - startOrdinal + 1) * 10);
        buf.append(this.start.getOsisID());
        for (int i = startOrdinal; i < endOrdinal; ++i) {
            try {
                buf.append(" ");
                buf.append(new Verse(i).getOsisID());
                continue;
            }
            catch (NoSuchVerseException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)e);
                }
                continue;
            }
        }
        if (startOrdinal != endOrdinal) {
            buf.append(" ");
            buf.append(this.end.getOsisID());
        }
        return buf.toString();
    }

    public String toString() {
        return this.getName();
    }

    public Verse getStart() {
        return this.start;
    }

    public Verse getEnd() {
        return this.end;
    }

    public int getVerseCount() {
        return this.verseCount;
    }

    public int getChapterCount() {
        int startBook = this.start.getBook();
        int startChap = this.start.getChapter();
        int endBook = this.end.getBook();
        int endChap = this.end.getChapter();
        if (startBook == endBook) {
            return endChap - startChap + 1;
        }
        try {
            int total = BibleInfo.chaptersInBook(startBook) - startChap;
            for (int b = startBook + 1; b < endBook; ++b) {
                total += BibleInfo.chaptersInBook(b);
            }
            return total += endChap;
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return 1;
        }
    }

    public int getBookCount() {
        int startBook = this.start.getBook();
        int endBook = this.end.getBook();
        return endBook - startBook + 1;
    }

    public Object clone() {
        VerseRange copy;
        block2: {
            copy = null;
            try {
                copy = (VerseRange)super.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        copy.start = (Verse)this.start.clone();
        copy.end = (Verse)this.end.clone();
        copy.verseCount = this.verseCount;
        copy.originalName = this.originalName;
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        VerseRange vr = (VerseRange)obj;
        if (!vr.getStart().equals(this.getStart())) {
            return false;
        }
        return vr.getVerseCount() == this.getVerseCount();
    }

    public int hashCode() {
        return (this.start.getOrdinal() << 16) + this.verseCount;
    }

    public int compareTo(Object obj) {
        Verse that = null;
        that = obj instanceof Verse ? (Verse)obj : ((VerseRange)obj).getStart();
        int start_compare = this.getStart().compareTo(that);
        if (start_compare != 0) {
            return start_compare;
        }
        int that_length = 1;
        if (obj instanceof VerseRange) {
            that_length = ((VerseRange)obj).getVerseCount();
        }
        if (that_length == this.getVerseCount()) {
            return 0;
        }
        if (that_length < this.getVerseCount()) {
            return 1;
        }
        return -1;
    }

    public boolean adjacentTo(VerseRange that) {
        int thatStart = that.getStart().getOrdinal();
        int thatEnd = that.getEnd().getOrdinal();
        int thisStart = this.getStart().getOrdinal();
        int thisEnd = this.getEnd().getOrdinal();
        if (thatStart >= thisStart - 1 && thatStart <= thisEnd + 1) {
            return true;
        }
        return thisStart >= thatStart - 1 && thisStart <= thatEnd + 1;
    }

    public boolean overlaps(VerseRange that) {
        int thatStart = that.getStart().getOrdinal();
        int thatEnd = that.getEnd().getOrdinal();
        int thisStart = this.getStart().getOrdinal();
        int thisEnd = this.getEnd().getOrdinal();
        if (thatStart >= thisStart && thatStart <= thisEnd) {
            return true;
        }
        return thisStart >= thatStart && thisStart <= thatEnd;
    }

    public boolean contains(Verse that) {
        if (this.start.compareTo(that) == 1) {
            return false;
        }
        return this.end.compareTo(that) != -1;
    }

    public boolean contains(VerseRange that) {
        if (this.start.compareTo(that.getStart()) == 1) {
            return false;
        }
        return this.end.compareTo(that.getEnd()) != -1;
    }

    public boolean isWholeChapter() {
        if (!this.start.isStartOfChapter()) {
            return false;
        }
        if (!this.end.isEndOfChapter()) {
            return false;
        }
        return this.start.isSameChapter(this.end);
    }

    public boolean isWholeChapters() {
        if (!this.start.isStartOfChapter()) {
            return false;
        }
        return this.end.isEndOfChapter();
    }

    public boolean isWholeBook() {
        if (!this.start.isStartOfBook()) {
            return false;
        }
        if (!this.end.isEndOfBook()) {
            return false;
        }
        return this.start.isSameBook(this.end);
    }

    public boolean isWholeBooks() {
        if (!this.start.isStartOfBook()) {
            return false;
        }
        return this.end.isEndOfBook();
    }

    public boolean isMultipleBooks() {
        return this.start.getBook() != this.end.getBook();
    }

    public Verse[] toVerseArray() {
        try {
            Verse[] retcode = new Verse[this.verseCount];
            for (int i = 0; i < this.verseCount; ++i) {
                retcode[i] = new Verse(this.start.getOrdinal() + i);
            }
            return retcode;
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return new Verse[0];
        }
    }

    public Iterator rangeIterator(RestrictionType restrict) {
        return new AbstractPassage.VerseRangeIterator(this.iterator(), restrict);
    }

    public Key getParent() {
        return this.parent;
    }

    public void setParent(Key parent) {
        this.parent = parent;
    }

    public static VerseRange[] remainder(VerseRange a, VerseRange b) {
        VerseRange rstart = null;
        VerseRange rend = null;
        if (a.getStart().compareTo(b.getStart()) == -1) {
            rstart = new VerseRange(a.getStart(), b.getEnd().subtract(1));
        }
        if (a.getEnd().compareTo(b.getEnd()) == 1) {
            rend = new VerseRange(b.getEnd().add(1), a.getEnd());
        }
        if (rstart == null) {
            if (rend == null) {
                return new VerseRange[0];
            }
            return new VerseRange[]{rend};
        }
        if (rend == null) {
            return new VerseRange[]{rstart};
        }
        return new VerseRange[]{rstart, rend};
    }

    public static VerseRange intersection(VerseRange a, VerseRange b) {
        Verse new_end;
        Verse new_start = Verse.max(a.getStart(), b.getStart());
        if (new_start.compareTo(new_end = Verse.min(a.getEnd(), b.getEnd())) < 1) {
            return new VerseRange(new_start, new_end);
        }
        return null;
    }

    public static VerseRange getWholeBibleVerseRange() {
        try {
            if (whole == null) {
                whole = new VerseRange(new Verse(1, 1, 1), new Verse(66, 22, 21));
            }
        }
        catch (NoSuchVerseException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return new VerseRange();
        }
        return whole;
    }

    private static Verse calcEnd(Verse start, int verseCount) {
        return start.add(verseCount - 1);
    }

    private static int calcVerseCount(Verse start, Verse end) {
        return end.subtract(start) + 1;
    }

    private void verifyData() {
        if (!$assertionsDisabled && this.verseCount != this.end.subtract(this.start) + 1) {
            throw new AssertionError((Object)("start=" + this.start + ", end=" + this.end + ", verseCount=" + this.verseCount));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.start.getOrdinal());
        out.writeInt(this.verseCount);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.start = new Verse(in.readInt());
            this.verseCount = in.readInt();
            this.end = VerseRange.calcEnd(this.start, this.verseCount);
            this.verifyData();
        }
        catch (NoSuchVerseException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public boolean canHaveChildren() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean contains(Key key) {
        if (key instanceof VerseRange) {
            return this.contains((VerseRange)key);
        }
        return false;
    }

    public Iterator iterator() {
        return new VerseIterator(this);
    }

    public void addAll(Key key) {
        throw new UnsupportedOperationException();
    }

    public void removeAll(Key key) {
        throw new UnsupportedOperationException();
    }

    public void retainAll(Key key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
    }

    public Key get(int index) {
        return null;
    }

    public int indexOf(Key that) {
        return -1;
    }

    public void blur(int by, RestrictionType restrict) {
        VerseRange newRange = restrict.blur(this, by, by);
        this.start = newRange.start;
        this.end = newRange.end;
        this.verseCount = newRange.verseCount;
    }

    static {
        $assertionsDisabled = !VerseRange.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)VerseRange.class);
    }

    private static final class VerseIterator
    implements Iterator {
        private int next;
        private int last;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected VerseIterator(VerseRange range) {
            this.next = range.getStart().getOrdinal();
            this.last = range.getEnd().getOrdinal();
        }

        public boolean hasNext() {
            return this.next <= this.last;
        }

        public Object next() throws NoSuchElementException {
            if (this.next > this.last) {
                throw new NoSuchElementException();
            }
            try {
                return new Verse(this.next++);
            }
            catch (NoSuchVerseException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                return Verse.DEFAULT;
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        static {
            $assertionsDisabled = !(class$org$crosswire$jsword$passage$VerseRange == null ? (class$org$crosswire$jsword$passage$VerseRange = VerseRange.class$("org.crosswire.jsword.passage.VerseRange")) : class$org$crosswire$jsword$passage$VerseRange).desiredAssertionStatus();
        }
    }
}

