/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.Serializable;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;

public abstract class AccuracyType
implements Serializable {
    public static final AccuracyType BOOK_VERSE;
    public static final AccuracyType BOOK_CHAPTER;
    public static final AccuracyType BOOK_ONLY;
    public static final AccuracyType CHAPTER_VERSE;
    public static final AccuracyType CHAPTER_ONLY;
    public static final AccuracyType VERSE_ONLY;
    public static final String VERSE_ALLOWED_DELIMS = " :.";
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final AccuracyType[] VALUES;
    public static final String VERSE_END_MARK1 = "$";
    public static final String VERSE_END_MARK2 = "ff";
    static final /* synthetic */ boolean $assertionsDisabled;

    public AccuracyType(String name) {
        this.name = name;
    }

    public abstract Verse createStartVerse(String var1, VerseRange var2, String[] var3) throws NoSuchVerseException;

    public abstract Verse createEndVerse(String var1, Verse var2, String[] var3) throws NoSuchVerseException;

    public boolean isBook() {
        return false;
    }

    public boolean isChapter() {
        return false;
    }

    public boolean isVerse() {
        return false;
    }

    public static final int getChapter(int lbook, String chapter) throws NoSuchVerseException {
        if (AccuracyType.isEndMarker(chapter)) {
            return BibleInfo.chaptersInBook(lbook);
        }
        return AccuracyType.parseInt(chapter);
    }

    public static final int getVerse(int lbook, int lchapter, String verse) throws NoSuchVerseException {
        if (AccuracyType.isEndMarker(verse)) {
            return BibleInfo.versesInChapter(lbook, lchapter);
        }
        return AccuracyType.parseInt(verse);
    }

    public int toInteger() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!this.equals(VALUES[i])) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public static AccuracyType fromText(String original, String[] parts) throws NoSuchVerseException {
        return AccuracyType.fromText(original, parts, null, null);
    }

    public static AccuracyType fromText(String original, String[] parts, AccuracyType verseAccuracy) throws NoSuchVerseException {
        return AccuracyType.fromText(original, parts, verseAccuracy, null);
    }

    public static AccuracyType fromText(String original, String[] parts, VerseRange basis) throws NoSuchVerseException {
        return AccuracyType.fromText(original, parts, null, basis);
    }

    public static AccuracyType fromText(String original, String[] parts, AccuracyType verseAccuracy, VerseRange basis) throws NoSuchVerseException {
        String msg = original;
        switch (parts.length) {
            case 1: {
                if (BibleInfo.isBookName(parts[0])) {
                    return BOOK_ONLY;
                }
                AccuracyType.checkValidChapterOrVerse(parts[0]);
                if (verseAccuracy != null) {
                    if (verseAccuracy.isVerse()) {
                        return VERSE_ONLY;
                    }
                    if (verseAccuracy.isChapter()) {
                        return CHAPTER_ONLY;
                    }
                }
                if (basis != null) {
                    if (basis.isWholeChapter()) {
                        return CHAPTER_ONLY;
                    }
                    return VERSE_ONLY;
                }
                for (int i = 0; i < parts.length; ++i) {
                    msg = msg + ", ";
                    msg = msg + parts[1];
                }
                throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARTS, new Object[]{msg});
            }
            case 2: {
                int pbook = BibleInfo.getBookNumber(parts[0]);
                if (pbook == -1) {
                    AccuracyType.checkValidChapterOrVerse(parts[0]);
                    AccuracyType.checkValidChapterOrVerse(parts[1]);
                    return CHAPTER_VERSE;
                }
                if (BibleInfo.chaptersInBook(pbook) == 1) {
                    return BOOK_VERSE;
                }
                return BOOK_CHAPTER;
            }
            case 3: {
                if (BibleInfo.getBookNumber(parts[0]) != -1) {
                    AccuracyType.checkValidChapterOrVerse(parts[1]);
                    AccuracyType.checkValidChapterOrVerse(parts[2]);
                    return BOOK_VERSE;
                }
                for (int i = 0; i < parts.length; ++i) {
                    msg = msg + ", ";
                    msg = msg + parts[1];
                }
                throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARTS, new Object[]{msg});
            }
        }
        for (int i = 0; i < parts.length; ++i) {
            msg = msg + ", ";
            msg = msg + parts[1];
        }
        throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARTS, new Object[]{msg});
    }

    private static void checkValidChapterOrVerse(String text) throws NoSuchVerseException {
        if (!AccuracyType.isEndMarker(text)) {
            AccuracyType.parseInt(text);
        }
    }

    private static int parseInt(String text) throws NoSuchVerseException {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARSE, new Object[]{text});
        }
    }

    private static boolean isEndMarker(String text) {
        if (text.equals(VERSE_END_MARK1)) {
            return true;
        }
        return text.equals(VERSE_END_MARK2);
    }

    public static String[] tokenize(String input) {
        String[] args = new String[]{null, null, null, null, null, null, null, null};
        int length = input.length();
        char[] normalized = new char[length * 2];
        char lastChar = '0';
        char curChar = ' ';
        int tokenCount = 0;
        int normalizedLength = 0;
        int startIndex = 0;
        String token = null;
        boolean foundBoundary = false;
        for (int i = 0; i < length; ++i) {
            boolean charIsDigit;
            curChar = input.charAt(i);
            boolean bl = curChar == '$' || Character.isDigit(curChar) || curChar == 'f' && (i + 1 < length ? (int)input.charAt(i + 1) : 32) == 102 ? true : (charIsDigit = false);
            if (charIsDigit || Character.isLetter(curChar)) {
                boolean charWasDigit;
                foundBoundary = true;
                boolean bl2 = lastChar == '$' || Character.isDigit(lastChar) || lastChar == 'f' && (i > 2 ? (int)input.charAt(i - 2) : 48) == 102 ? true : (charWasDigit = false);
                if (charWasDigit || Character.isLetter(lastChar)) {
                    foundBoundary = false;
                    if (normalizedLength > 0 && charWasDigit != charIsDigit) {
                        foundBoundary = true;
                    }
                }
                if (foundBoundary) {
                    if (charIsDigit) {
                        token = new String(normalized, startIndex, normalizedLength - startIndex);
                        args[tokenCount++] = token;
                        normalizedLength = 0;
                    } else {
                        normalized[normalizedLength++] = 32;
                    }
                }
                normalized[normalizedLength++] = curChar;
            }
            if (normalizedLength <= 0) continue;
            lastChar = curChar;
        }
        token = new String(normalized, startIndex, normalizedLength - startIndex);
        args[tokenCount++] = token;
        String[] results = new String[tokenCount];
        System.arraycopy(args, 0, results, 0, tokenCount);
        return results;
    }

    public static AccuracyType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            AccuracyType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static AccuracyType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !AccuracyType.class.desiredAssertionStatus();
        BOOK_VERSE = new AccuracyType("BOOK_VERSE"){
            private static final long serialVersionUID = 3256719589483165495L;

            public boolean isVerse() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = BibleInfo.getBookNumber(parts[0]);
                int chapter = 1;
                int verse = 1;
                if (parts.length == 3) {
                    chapter = 1.getChapter(book, parts[1]);
                    verse = 1.getVerse(book, chapter, parts[2]);
                } else {
                    verse = 1.getVerse(book, chapter, parts[1]);
                }
                return new Verse(original, book, chapter, verse);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                return this.createStartVerse(endVerseDesc, null, endParts);
            }
        };
        BOOK_CHAPTER = new AccuracyType("BOOK_CHAPTER"){
            private static final long serialVersionUID = 3258125864737911609L;

            public boolean isChapter() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = BibleInfo.getBookNumber(parts[0]);
                int chapter = 2.getChapter(book, parts[1]);
                int verse = 1;
                return new Verse(original, book, chapter, verse);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                Verse end = this.createStartVerse(endVerseDesc, null, endParts);
                return end.getLastVerseInChapter();
            }
        };
        BOOK_ONLY = new AccuracyType("BOOK_ONLY"){
            private static final long serialVersionUID = 4050486707419821620L;

            public boolean isBook() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = BibleInfo.getBookNumber(parts[0]);
                return new Verse(original, book, 1, 1);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                Verse end = this.createStartVerse(endVerseDesc, null, endParts);
                return end.getLastVerseInBook();
            }
        };
        CHAPTER_VERSE = new AccuracyType("CHAPTER_VERSE"){
            private static final long serialVersionUID = 3691040958808668471L;

            public boolean isVerse() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = verseRangeBasis.getEnd().getBook();
                int chapter = 4.getChapter(book, parts[0]);
                int verse = 4.getVerse(book, chapter, parts[1]);
                return new Verse(original, book, chapter, verse);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                int book = verseBasis.getBook();
                int chapter = 4.getChapter(book, endParts[0]);
                int verse = 4.getVerse(book, chapter, endParts[1]);
                return new Verse(endVerseDesc, book, chapter, verse);
            }
        };
        CHAPTER_ONLY = new AccuracyType("CHAPTER_ONLY"){
            private static final long serialVersionUID = 3689918357520463409L;

            public boolean isChapter() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = verseRangeBasis.getEnd().getBook();
                int chapter = 5.getChapter(book, parts[0]);
                return new Verse(original, book, chapter, 1);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                int book = verseBasis.getBook();
                int chapter = 5.getChapter(book, endParts[0]);
                Verse end = new Verse(endVerseDesc, book, chapter, 1);
                return end.getLastVerseInChapter();
            }
        };
        VERSE_ONLY = new AccuracyType("VERSE_ONLY"){
            private static final long serialVersionUID = 3691034361722320178L;

            public boolean isVerse() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = verseRangeBasis.getEnd().getBook();
                int chapter = verseRangeBasis.getEnd().getChapter();
                int verse = 6.getVerse(book, chapter, parts[0]);
                return new Verse(original, book, chapter, verse);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                int book = verseBasis.getBook();
                int chapter = verseBasis.getChapter();
                int verse = 6.getVerse(book, chapter, endParts[0]);
                return new Verse(endVerseDesc, book, chapter, verse);
            }
        };
        VALUES = new AccuracyType[]{BOOK_CHAPTER, BOOK_VERSE, BOOK_ONLY, CHAPTER_VERSE, VERSE_ONLY};
    }
}

