/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.util.Iterator;
import java.util.List;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractPassageBook;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Verse;
import org.jdom.Content;
import org.jdom.Element;

public class SwordBook
extends AbstractPassageBook {
    private AbstractBackend backend;
    private SwordBookMetaData sbmd;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SwordBook(SwordBookMetaData sbmd, AbstractBackend backend) {
        this.setBookMetaData(sbmd);
        this.sbmd = sbmd;
        this.backend = backend;
    }

    public final void activate(Lock lock) {
        super.activate(lock);
    }

    public final void deactivate(Lock lock) {
        super.deactivate(lock);
        Activator.deactivate((Activatable)this.backend);
    }

    protected String getText(Key key) throws BookException {
        if (this.backend == null) {
            return "";
        }
        String result = this.backend.getRawText(key);
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return result;
    }

    public void addOSIS(Key key, Element div, List osisContent) {
        Iterator iter = osisContent.iterator();
        while (iter.hasNext()) {
            Element ele;
            Object obj = iter.next();
            if (!(obj instanceof Element) || !(ele = (Element)obj).getName().equals("verse")) continue;
            super.addOSIS(key, div, osisContent);
            return;
        }
        Element everse = OSISUtil.factory().createVerse();
        everse.setAttribute("osisID", key.getOsisID());
        div.addContent((Content)everse);
        super.addOSIS(key, everse, osisContent);
    }

    protected void setText(Verse verse, String text) throws BookException {
        throw new BookException(Msg.DRIVER_READONLY);
    }

    protected Filter getFilter() {
        return this.sbmd.getFilter();
    }

    static {
        $assertionsDisabled = !SwordBook.class.desiredAssertionStatus();
    }
}

