/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.thml;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.filter.thml.ATag;
import org.crosswire.jsword.book.filter.thml.AliasTag;
import org.crosswire.jsword.book.filter.thml.BTag;
import org.crosswire.jsword.book.filter.thml.BlockquoteTag;
import org.crosswire.jsword.book.filter.thml.BrTag;
import org.crosswire.jsword.book.filter.thml.CenterTag;
import org.crosswire.jsword.book.filter.thml.CitationTag;
import org.crosswire.jsword.book.filter.thml.DivTag;
import org.crosswire.jsword.book.filter.thml.FontTag;
import org.crosswire.jsword.book.filter.thml.ForeignTag;
import org.crosswire.jsword.book.filter.thml.HrTag;
import org.crosswire.jsword.book.filter.thml.ITag;
import org.crosswire.jsword.book.filter.thml.IgnoreTag;
import org.crosswire.jsword.book.filter.thml.LiTag;
import org.crosswire.jsword.book.filter.thml.NameTag;
import org.crosswire.jsword.book.filter.thml.NoteTag;
import org.crosswire.jsword.book.filter.thml.OlTag;
import org.crosswire.jsword.book.filter.thml.PTag;
import org.crosswire.jsword.book.filter.thml.PbTag;
import org.crosswire.jsword.book.filter.thml.RootTag;
import org.crosswire.jsword.book.filter.thml.ScripRefTag;
import org.crosswire.jsword.book.filter.thml.ScriptureTag;
import org.crosswire.jsword.book.filter.thml.SmallTag;
import org.crosswire.jsword.book.filter.thml.SupTag;
import org.crosswire.jsword.book.filter.thml.SyncTag;
import org.crosswire.jsword.book.filter.thml.TableTag;
import org.crosswire.jsword.book.filter.thml.Tag;
import org.crosswire.jsword.book.filter.thml.TdTag;
import org.crosswire.jsword.book.filter.thml.TermTag;
import org.crosswire.jsword.book.filter.thml.ThTag;
import org.crosswire.jsword.book.filter.thml.TrTag;
import org.crosswire.jsword.book.filter.thml.UTag;
import org.crosswire.jsword.book.filter.thml.UlTag;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CustomHandler
extends DefaultHandler {
    private Element rootElement;
    private LinkedList stack = new LinkedList();
    private static final Map TAG_MAP = new HashMap();
    private static final Logger log;

    public void startElement(String uri, String localname, String qname, Attributes attrs) throws SAXException {
        Element ele = null;
        if (this.stack.size() > 0 && (ele = (Element)this.stack.getFirst()) == null) {
            return;
        }
        Tag t = (Tag)TAG_MAP.get(qname);
        if (t == null) {
            t = (Tag)TAG_MAP.get(qname.toLowerCase());
            if (t == null) {
                log.warn("unknown thml element: " + localname + " qname=" + qname);
                return;
            }
            DataPolice.report("Wrong case used in thml element: " + qname);
        }
        this.stack.addFirst(t.processTag(ele, attrs));
    }

    public void characters(char[] data, int offset, int length) {
        Content last;
        Element current = (Element)this.stack.getFirst();
        if (current == null) {
            return;
        }
        int size = current.getContentSize();
        String text = new String(data, offset, length);
        if (size > 0 && (last = current.getContent(size - 1)) instanceof Text) {
            current.removeContent(size - 1);
            text = ((Text)last).getText() + text;
        }
        current.addContent((Content)new Text(text));
    }

    public void endElement(String uri, String localname, String qname) {
        Element finished = (Element)this.stack.removeFirst();
        if (this.stack.size() == 0) {
            this.rootElement = finished;
        }
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    static {
        Tag[] tags = new Tag[]{new ATag(), new BlockquoteTag(), new BrTag(), new BTag(), new CenterTag(), new CitationTag(), new DivTag(), new ForeignTag(), new FontTag(), new HrTag(), new ITag(), new LiTag(), new NoteTag(), new NameTag(), new OlTag(), new PTag(), new PbTag(), new RootTag(), new ScriptureTag(), new ScripRefTag(), new SmallTag(), new SupTag(), new SyncTag(), new TableTag(), new TdTag(), new TermTag(), new ThTag(), new TrTag(), new UTag(), new UlTag(), new AliasTag("h1", new BTag()), new AliasTag("h2", new BTag()), new AliasTag("h3", new BTag()), new AliasTag("h4", new BTag()), new AliasTag("dl", new UlTag()), new AliasTag("dd", new LiTag()), new AliasTag("dt", new LiTag()), new IgnoreTag("img"), new IgnoreTag("span"), new IgnoreTag("dir"), new IgnoreTag("pre")};
        for (int i = 0; i < tags.length; ++i) {
            Tag t = tags[i];
            String tagName = t.getTagName();
            TAG_MAP.put(tagName, t);
        }
        log = Logger.getLogger((Class)CustomHandler.class);
    }
}

