/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.beans.PropertyChangeListener;
import java.util.Map;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.IndexStatus;
import org.crosswire.jsword.book.basic.Msg;
import org.crosswire.jsword.book.search.SearchRequest;
import org.crosswire.jsword.book.search.Searcher;
import org.crosswire.jsword.book.search.SearcherFactory;
import org.crosswire.jsword.book.search.basic.DefaultSearchRequest;
import org.crosswire.jsword.passage.Key;
import org.jdom.Document;

public abstract class AbstractBook
implements Book {
    private Searcher searcher;
    private BookMetaData bmd;

    public final BookMetaData getBookMetaData() {
        return this.bmd;
    }

    public final void setBookMetaData(BookMetaData bmd) {
        this.bmd = bmd;
    }

    public void activate(Lock lock) {
    }

    public void deactivate(Lock lock) {
    }

    public Key find(String request) throws BookException {
        return this.find(new DefaultSearchRequest(request));
    }

    public Key find(SearchRequest request) throws BookException {
        if (this.searcher == null) {
            try {
                this.searcher = SearcherFactory.createSearcher(this);
            }
            catch (InstantiationException ex) {
                throw new BookException((MsgBase)Msg.INDEX_FAIL, ex);
            }
        }
        return this.searcher.search(request);
    }

    public Book getBook() {
        return this;
    }

    public BookDriver getDriver() {
        return this.bmd.getDriver();
    }

    public String getDriverName() {
        return this.bmd.getDriverName();
    }

    public String getFullName() {
        return this.bmd.getFullName();
    }

    public IndexStatus getIndexStatus() {
        return this.bmd.getIndexStatus();
    }

    public void setIndexStatus(IndexStatus status) {
        this.bmd.setIndexStatus(status);
    }

    public String getInitials() {
        return this.bmd.getInitials();
    }

    public String getLanguage() {
        return this.bmd.getLanguage();
    }

    public String getName() {
        return this.bmd.getName();
    }

    public String getOsisID() {
        return this.bmd.getOsisID();
    }

    public Map getProperties() {
        return this.bmd.getProperties();
    }

    public BookCategory getBookCategory() {
        return this.bmd.getBookCategory();
    }

    public boolean isLeftToRight() {
        return this.bmd.isLeftToRight();
    }

    public boolean isSupported() {
        return this.bmd.isSupported();
    }

    public boolean isEnciphered() {
        return this.bmd.isEnciphered();
    }

    public boolean isQuestionable() {
        return this.bmd.isQuestionable();
    }

    public boolean hasFeature(FeatureType feature) {
        return this.bmd.hasFeature(feature);
    }

    public void removePropertyChangeListener(PropertyChangeListener li) {
        this.bmd.removePropertyChangeListener(li);
    }

    public void addPropertyChangeListener(PropertyChangeListener li) {
        this.bmd.addPropertyChangeListener(li);
    }

    public Document toOSIS() {
        return this.bmd.toOSIS();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Book that = (Book)obj;
        return this.bmd.equals(that.getBookMetaData());
    }

    public int hashCode() {
        return this.bmd.hashCode();
    }

    public int compareTo(Object obj) {
        Book that = (Book)obj;
        return this.bmd.compareTo(that.getBookMetaData());
    }

    public String toString() {
        return this.bmd.toString();
    }
}

