/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import org.crosswire.common.util.Msg;

public class EventListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY;
    protected transient Object[] listenerList = NULL_ARRAY;
    private static final long serialVersionUID = 3256999960636436785L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public synchronized void add(Class t, EventListener li) {
        if (!$assertionsDisabled && li == null) {
            throw new AssertionError();
        }
        if (!t.isInstance(li)) {
            throw new IllegalArgumentException(Msg.WRONG_TYPE.toString(new Object[]{li, t}));
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{t, li};
        } else {
            int i = this.listenerList.length;
            Object[] tmp = new Object[i + 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            tmp[i] = t;
            tmp[i + 1] = li;
            this.listenerList = tmp;
        }
    }

    public synchronized void remove(Class t, EventListener li) {
        if (!$assertionsDisabled && li == null) {
            throw new AssertionError();
        }
        if (!t.isInstance(li)) {
            throw new IllegalArgumentException(Msg.WRONG_TYPE.toString(new Object[]{li, t}));
        }
        int index = -1;
        for (int i = this.listenerList.length - 2; i >= 0; i -= 2) {
            if (this.listenerList[i] != t || !this.listenerList[i + 1].equals(li)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listenerList, index + 2, tmp, index, tmp.length - index);
            }
            this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Object[] lList = this.listenerList;
        oos.defaultWriteObject();
        for (int i = 0; i < lList.length; i += 2) {
            Class t = (Class)lList[i];
            EventListener li = (EventListener)lList[i + 1];
            if (li == null || !(li instanceof Serializable)) continue;
            oos.writeObject(t.getName());
            oos.writeObject(li);
        }
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object listenerTypeOrNull;
        this.listenerList = NULL_ARRAY;
        ois.defaultReadObject();
        while ((listenerTypeOrNull = ois.readObject()) != null) {
            EventListener li = (EventListener)ois.readObject();
            this.add(Class.forName((String)listenerTypeOrNull), li);
        }
    }

    public String toString() {
        Object[] lList = this.listenerList;
        StringBuffer s = new StringBuffer("EventListenerList: ");
        s.append(lList.length / 2);
        s.append(" listeners: ");
        for (int i = 0; i <= lList.length - 2; i += 2) {
            s.append(" type ");
            s.append(((Class)lList[i]).getName());
            s.append(" listener ");
            s.append(lList[i + 1]);
        }
        return s.toString();
    }

    static {
        $assertionsDisabled = !EventListenerList.class.desiredAssertionStatus();
        NULL_ARRAY = new Object[0];
    }
}

