/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import org.crosswire.common.swing.AbstractLayout;

public class FieldLayout
extends AbstractLayout {
    private static final long serialVersionUID = 3617576015757719097L;

    public FieldLayout() {
    }

    public FieldLayout(int hgap, int vgap) {
        super(hgap, vgap);
    }

    public Dimension minimumLayoutSize(Container target) {
        int left = 0;
        int right = 0;
        int height = 0;
        Insets insets = target.getInsets();
        int ncomponents = target.getComponentCount();
        for (int i = 0; i < ncomponents; i += 2) {
            Component label = target.getComponent(i);
            int w1 = label.getMinimumSize().width;
            int h1 = label.getMinimumSize().height;
            if (w1 > left) {
                left = w1;
            }
            if (i + 1 < ncomponents) {
                Component field = target.getComponent(i + 1);
                int w2 = field.getMinimumSize().width;
                int h2 = field.getMinimumSize().height;
                if (w2 > right) {
                    right = w2;
                }
                height += Math.max(h1, h2) + this.hgap;
                continue;
            }
            height += h1;
        }
        return new Dimension(insets.left + insets.right + left + right + this.vgap, insets.top + insets.bottom + height - this.hgap);
    }

    public Dimension preferredLayoutSize(Container target) {
        int left = 0;
        int right = 0;
        int height = 0;
        Insets insets = target.getInsets();
        int ncomponents = target.getComponentCount();
        for (int i = 0; i < ncomponents; i += 2) {
            Component label = target.getComponent(i);
            int w1 = label.getPreferredSize().width;
            int h1 = label.getPreferredSize().height;
            if (w1 > left) {
                left = w1;
            }
            if (i + 1 < ncomponents) {
                Component field = target.getComponent(i + 1);
                int w2 = field.getPreferredSize().width;
                int h2 = field.getPreferredSize().height;
                if (w2 > right) {
                    right = w2;
                }
                height += Math.max(h1, h2) + this.hgap;
                continue;
            }
            height += h1;
        }
        return new Dimension(insets.left + insets.right + left + right + this.vgap, insets.top + insets.bottom + height - this.hgap);
    }

    public void layoutContainer(Container target) {
        int left = 0;
        Insets insets = target.getInsets();
        int ncomponents = target.getComponentCount();
        for (int i = 0; i < ncomponents; i += 2) {
            Component label = target.getComponent(i);
            int w = label.getPreferredSize().width;
            if (w <= left) continue;
            left = w;
        }
        int right = target.getSize().width - left - insets.left - insets.right - this.hgap;
        int vpos = insets.top;
        for (int i = 0; i < ncomponents; i += 2) {
            Component label = target.getComponent(i);
            int h1 = label.getPreferredSize().height;
            int h2 = 0;
            Component field = null;
            if (i + 1 < ncomponents) {
                field = target.getComponent(i + 1);
                h2 = field.getPreferredSize().height;
            }
            int h = Math.max(h1, h2);
            label.setBounds(insets.left, vpos, left, h);
            if (field != null) {
                field.setBounds(insets.left + left + this.hgap, vpos, right, h);
            }
            vpos += h + this.hgap;
        }
    }
}

