/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import org.crosswire.bibledesktop.book.BibleViewPane;
import org.crosswire.bibledesktop.book.install.SitesPane;
import org.crosswire.bibledesktop.desktop.AboutPane;
import org.crosswire.bibledesktop.desktop.Desktop;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.bibledesktop.desktop.ViewSourcePane;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.splitlist.SplitBookDataDisplay;
import org.crosswire.bibledesktop.display.tab.TabbedBookDataDisplay;
import org.crosswire.common.config.Config;
import org.crosswire.common.config.swing.ConfigEditorFactory;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.desktop.ViewVisitor;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.util.Project;

public class DesktopActions {
    static final String FILE = "File";
    static final String EDIT = "Edit";
    static final String GO = "Go";
    static final String VIEW = "View";
    static final String TOOLS = "Tools";
    static final String HELP = "Help";
    static final String OPEN = "Open";
    static final String SAVE = "Save";
    static final String SAVE_AS = "SaveAs";
    static final String SAVE_ALL = "SaveAll";
    static final String EXIT = "Exit";
    static final String COPY = "Copy";
    static final String BACK = "Back";
    static final String FORWARD = "Forward";
    static final String TOOLTIP_TOGGLE = "ToolTipToggle";
    static final String STATUS_TOGGLE = "StatusToggle";
    static final String SIDEBAR_TOGGLE = "SidebarToggle";
    static final String VERSE = "Verse";
    static final String VIEW_SOURCE = "ViewSource";
    static final String BOOKS = "Books";
    static final String OPTIONS = "Options";
    static final String CONTENTS = "Contents";
    static final String ABOUT = "About";
    protected Desktop desktop;
    private transient ActionFactory actions;
    private AboutPane atp;
    private SitesPane sites;

    public DesktopActions(Desktop desktop) {
        this.desktop = desktop;
        this.actions = new ActionFactory(Desktop.class, (Object)this);
    }

    public Action getAction(String key) {
        return this.actions.getAction(key);
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public SitesPane getSites() {
        if (this.sites == null) {
            this.sites = new SitesPane();
        }
        return this.sites;
    }

    public void doOpen() {
        try {
            BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
            view.open();
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this.getDesktop(), (Throwable)ex);
        }
    }

    public void doSave() {
        try {
            BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
            if (!view.maySave()) {
                Reporter.informUser((Object)this.getDesktop(), (MsgBase)Msg.NO_PASSAGE);
                return;
            }
            view.save();
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this.getDesktop(), (Throwable)ex);
        }
    }

    public void doSaveAs() {
        try {
            BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
            if (!view.maySave()) {
                Reporter.informUser((Object)this.getDesktop(), (MsgBase)Msg.NO_PASSAGE);
                return;
            }
            view.saveAs();
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this.getDesktop(), (Throwable)ex);
        }
    }

    public void doSaveAll() {
        BibleViewPane view;
        boolean ok = false;
        Iterator it = this.getDesktop().getViews().iterator();
        while (it.hasNext()) {
            view = (BibleViewPane)((Object)it.next());
            if (!view.maySave()) continue;
            ok = true;
        }
        if (!ok) {
            Reporter.informUser((Object)this.getDesktop(), (MsgBase)Msg.NO_PASSAGE);
            return;
        }
        it = this.getDesktop().getViews().iterator();
        while (it.hasNext()) {
            try {
                view = (BibleViewPane)((Object)it.next());
                view.save();
            }
            catch (IOException ex) {
                Reporter.informUser((Object)this.getDesktop(), (Throwable)ex);
            }
        }
    }

    public void doExit() {
        System.exit(0);
    }

    public void doCopy() {
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.copy();
    }

    public void doBack() {
        this.getDesktop().selectHistory(-1);
    }

    public void doForward() {
        this.getDesktop().selectHistory(1);
    }

    public void doStrongs(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.STRONGS_NUMBERS.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doMorph(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.MORPH.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doVLine(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.START_VERSE_ON_NEWLINE.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doVNum() {
        XSLTProperty.VERSE_NUMBERS.setState(true);
        XSLTProperty.CV.setState(false);
        XSLTProperty.BCV.setState(false);
        XSLTProperty.NO_VERSE_NUMBERS.setState(false);
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doTinyVNum(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.TINY_VERSE_NUMBERS.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doBCVNum() {
        XSLTProperty.VERSE_NUMBERS.setState(false);
        XSLTProperty.CV.setState(false);
        XSLTProperty.BCV.setState(true);
        XSLTProperty.NO_VERSE_NUMBERS.setState(false);
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doCVNum() {
        XSLTProperty.VERSE_NUMBERS.setState(false);
        XSLTProperty.CV.setState(true);
        XSLTProperty.BCV.setState(false);
        XSLTProperty.NO_VERSE_NUMBERS.setState(false);
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doNoVNum() {
        XSLTProperty.VERSE_NUMBERS.setState(false);
        XSLTProperty.CV.setState(false);
        XSLTProperty.BCV.setState(false);
        XSLTProperty.NO_VERSE_NUMBERS.setState(true);
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doNotes(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.NOTES.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doXRef(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.XREF.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doViewSource() {
        try {
            Key key;
            BibleViewPane view = (BibleViewPane)((Object)this.getDesktop().getViews().getSelected());
            SplitBookDataDisplay da = view.getPassagePane();
            BookDataDisplay bdd = da.getBookDataDisplay();
            if (bdd instanceof TabbedBookDataDisplay) {
                bdd = ((TabbedBookDataDisplay)bdd).getInnerDisplayPane();
            }
            if ((key = bdd.getKey()) == null) {
                Reporter.informUser((Object)this.getDesktop(), (MsgBase)Msg.SOURCE_MISSING);
                return;
            }
            Book book = da.getBook();
            ViewSourcePane viewer = new ViewSourcePane(book, key);
            viewer.showInFrame(this.getDesktop());
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this.getDesktop(), (Throwable)ex);
        }
    }

    public void doBooks() {
        this.getSites().showInDialog(this.getDesktop());
    }

    public void doOptions() {
        try {
            URL configUrl = Project.instance().getWritablePropertiesURL("desktop");
            ConfigEditorFactory.showDialog((Config)this.desktop.getConfig(), (Component)this.desktop, (URL)configUrl);
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this.desktop, (Throwable)ex);
        }
    }

    public void doContents() {
        JOptionPane.showMessageDialog(this.getDesktop(), (Object)Msg.NO_HELP);
    }

    public void doAbout() {
        if (this.atp == null) {
            this.atp = new AboutPane();
        }
        this.atp.showInDialog(this.getDesktop());
    }

    public void doToolTipToggle(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        ToolTipManager.sharedInstance().setEnabled(toggle.isSelected());
    }

    public void doStatusToggle(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        this.desktop.showStatusBar(toggle.isSelected());
    }

    public void doSidebarToggle(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        boolean show = toggle.isSelected();
        this.desktop.getViews().visit((ViewVisitor)new ShowSideBarVisitor(show));
    }

    private static final class ShowSideBarVisitor
    implements ViewVisitor {
        private boolean show;

        public ShowSideBarVisitor(boolean show) {
            this.show = show;
        }

        public void visitView(Component component) {
            BibleViewPane view = (BibleViewPane)((Object)component);
            SplitBookDataDisplay sbDisplay = view.getPassagePane();
            sbDisplay.showSidebar(this.show);
        }
    }
}

