/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search.parse;

import java.util.Iterator;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.search.Index;
import org.crosswire.jsword.book.search.parse.IndexSearcher;
import org.crosswire.jsword.book.search.parse.Msg;
import org.crosswire.jsword.book.search.parse.ParamWord;
import org.crosswire.jsword.book.search.parse.PassageRightParamWord;
import org.crosswire.jsword.book.search.parse.Word;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;

public class PassageLeftParamWord
implements ParamWord {
    public String getWord(IndexSearcher engine) throws BookException {
        throw new BookException(Msg.LEFT_PARAM);
    }

    public Key getKeyList(IndexSearcher engine) throws BookException {
        Iterator it = engine.iterator();
        StringBuffer buff = new StringBuffer();
        int paren_level = 1;
        while (true) {
            if (!it.hasNext()) {
                throw new BookException(Msg.LEFT_BRACKETS);
            }
            Word word = (Word)it.next();
            if (word instanceof PassageLeftParamWord) {
                ++paren_level;
            }
            if (word instanceof PassageRightParamWord) {
                --paren_level;
            }
            if (paren_level == 0) break;
            buff.append(word);
            buff.append(" ");
        }
        try {
            Index index = engine.getIndex();
            return index.getKey(buff.toString());
        }
        catch (NoSuchKeyException ex) {
            throw new BookException(Msg.ILLEGAL_PASSAGE, (Throwable)((Object)ex), new Object[]{buff.toString()});
        }
    }
}

