/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Iterator;
import java.util.List;
import org.crosswire.common.xml.JDOMSAXEventProvider;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.passage.Key;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BookData {
    private Book book;
    private Key key;
    private Element osis;

    public BookData(Element osis, Book book, Key key) {
        this.osis = osis;
        this.book = book;
        this.key = key;
    }

    public BookData(SAXEventProvider provider, Book book, Key key) throws SAXException {
        SAXHandler handler = new SAXHandler();
        provider.provideSAXEvents((ContentHandler)handler);
        this.osis = handler.getDocument().getRootElement();
        this.book = book;
        this.key = key;
    }

    public Element getOsis() {
        return this.osis;
    }

    public String getPlainText() {
        StringBuffer buffer = new StringBuffer();
        Element osisText = this.getOsis().getChild("osisText");
        List divs = osisText.getChildren("div");
        Iterator oit = divs.iterator();
        while (oit.hasNext()) {
            Element div = (Element)oit.next();
            Iterator dit = div.getContent().iterator();
            while (dit.hasNext()) {
                Element ele;
                Object data = dit.next();
                if (!(data instanceof Element) || !(ele = (Element)data).getName().equals("verse")) continue;
                String txt = OSISUtil.getPlainText((Element)data);
                buffer.append(txt);
            }
        }
        return buffer.toString().trim();
    }

    public void validate() {
    }

    public SAXEventProvider getSAXEventProvider() {
        return new JDOMSAXEventProvider(new Document(this.osis));
    }

    public Book getBook() {
        return this.book;
    }

    public Key getKey() {
        return this.key;
    }
}

