/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.crosswire.common.swing.RowTableModel;

public class SortRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 3977303200573765939L;
    private TableColumn pressedColumn;
    private RowTableModel model;

    public SortRenderer(RowTableModel stm) {
        this.model = stm;
        this.pressedColumn = null;
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table != null) {
            this.setToolTipText(this.model.getHeaderToolTip(column));
            JTableHeader header = table.getTableHeader();
            TableColumn tableColumn = table.getColumnModel().getColumn(column);
            if (header != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                Font headerFont = header.getFont();
                if (tableColumn == this.pressedColumn) {
                    this.setFont(headerFont.deriveFont(2));
                } else {
                    this.setFont(headerFont);
                }
            }
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    public TableColumn getPressedColumn() {
        return this.pressedColumn;
    }

    public void setPressedColumn(TableColumn tc) {
        this.pressedColumn = tc;
    }
}

