/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;

public class DebugContainerListener
implements ContainerListener {
    private Map map = new HashMap();
    private static final Logger log = Logger.getLogger(DebugContainerListener.class);

    public void componentAdded(ContainerEvent ev) {
        Component child = ev.getChild();
        Container cont = ev.getContainer();
        this.addChild(cont, child);
    }

    private void setAlert(Component comp, Color color) {
        comp.setBackground(color.brighter());
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.setBorder(BorderFactory.createLineBorder(color, 5));
        }
    }

    private void addChild(Container parent, Component child) {
        Container statedParent = child.getParent();
        if (statedParent == null) {
            log.warn("CL1: child:" + this.toString(child) + "(pink), claiming getParent()=null", new Exception());
            this.setAlert(child, Color.PINK);
        } else if (statedParent != parent) {
            log.warn("CL1: child:" + this.toString(child) + "(cyan), getParent()=" + this.toString(statedParent) + "(green) added under parent=" + this.toString(parent) + "(yellow)", new Exception());
            this.setAlert(child, Color.CYAN);
            this.setAlert(statedParent, Color.GREEN);
            this.setAlert(parent, Color.YELLOW);
        }
        Container lastKnownParent = (Container)this.map.get(child);
        if (lastKnownParent != null && lastKnownParent != parent) {
            log.warn("CL1: child:" + this.toString(child) + "(blue), altered reparent, old parent=" + this.toString(lastKnownParent) + "(magenta), new parent=" + this.toString(parent) + "(orange)", new Exception());
            this.setAlert(child, Color.BLUE);
            this.setAlert(lastKnownParent, Color.MAGENTA);
            this.setAlert(parent, Color.ORANGE);
        }
        this.map.put(child, parent);
        if (child instanceof Container) {
            Container cont = (Container)child;
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addChild(cont, children[i]);
            }
        }
    }

    private String toString(Component parent) {
        return ClassUtil.getShortClassName(parent, "Null") + '(' + parent.hashCode() + ')';
    }

    public void componentRemoved(ContainerEvent ev) {
        Component child = ev.getComponent();
        this.map.remove(child);
    }
}

