/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.display.splitlist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.passage.KeyChangeEvent;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.bibledesktop.passage.KeySidebar;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.passage.Key;

public class SplitBookDataDisplay
extends JPanel {
    private Key key;
    private transient List keyChangeListeners;
    private Book book;
    private static final Logger log = Logger.getLogger((Class)SplitBookDataDisplay.class);
    private KeySidebar sidebar;
    private JSplitPane split;
    private BookDataDisplay child;
    private static final long serialVersionUID = 3257283643176202806L;

    public SplitBookDataDisplay(KeySidebar sidebar, BookDataDisplay child) {
        this.child = child;
        this.sidebar = sidebar;
        this.init();
    }

    private void init() {
        this.split = new FixedSplitPane();
        this.split.setOrientation(1);
        this.split.setLeftComponent(this.sidebar);
        this.split.setRightComponent(this.child.getComponent());
        this.split.setOneTouchExpandable(true);
        this.split.setDividerLocation(0.0);
        this.split.setBorder(null);
        this.split.setDividerSize(8);
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public KeySidebar getSidebar() {
        return this.sidebar;
    }

    public BookDataDisplay getBookDataDisplay() {
        return this.child;
    }

    public void setBookData(Book book, Key key) {
        boolean keyChanged = this.key == null || !this.key.equals(key);
        boolean bookChanged = this.book == null || !this.book.equals(book);
        this.book = book;
        this.key = key;
        if (keyChanged) {
            log.debug("new passage chosen: " + key.getName());
            this.fireKeyChanged(new KeyChangeEvent(this, key));
        }
        if (bookChanged || keyChanged) {
            if (bookChanged) {
                log.debug("new bible chosen: " + book);
            }
            this.child.setBookData(book, key);
        }
    }

    public void showSidebar(boolean show) {
        Component childComponent = this.child.getComponent();
        if (show) {
            this.remove(childComponent);
            this.split.add(childComponent, "right");
            this.add(this.split);
        } else {
            this.remove(this.split);
            this.split.remove(childComponent);
            this.add(childComponent);
        }
        this.validate();
    }

    public Key getKey() {
        return this.key;
    }

    public Book getBook() {
        return this.book;
    }

    public void copy() {
        this.child.copy();
    }

    public synchronized void addKeyChangeListener(KeyChangeListener listener) {
        ArrayList<KeyChangeListener> temp = new ArrayList<KeyChangeListener>(2);
        if (this.keyChangeListeners != null) {
            temp.addAll(this.keyChangeListeners);
        }
        if (!temp.contains(listener)) {
            temp.add(listener);
            this.keyChangeListeners = temp;
        }
    }

    public synchronized void removeKeyChangeListener(KeyChangeListener listener) {
        if (this.keyChangeListeners != null && this.keyChangeListeners.contains(listener)) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.keyChangeListeners);
            temp.remove(listener);
            this.keyChangeListeners = temp;
        }
    }

    protected void fireKeyChanged(KeyChangeEvent ev) {
        if (this.keyChangeListeners != null) {
            for (int i = 0; i < this.keyChangeListeners.size(); ++i) {
                KeyChangeListener listener = (KeyChangeListener)this.keyChangeListeners.get(i);
                listener.keyChanged(ev);
            }
        }
    }
}

