/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.crosswire.bibledesktop.book.BibleViewPane;
import org.crosswire.bibledesktop.desktop.Desktop;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.bibledesktop.desktop.Splash;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.util.Project;

public class DebugPane
extends JPanel {
    private Splash splash;
    protected static final Logger log = Logger.getLogger((Class)DebugPane.class);
    private Desktop desktop;
    private DefaultComboBoxModel mdlMethods = new DefaultComboBoxModel();
    private JScrollPane scrResults = new JScrollPane();
    private JPanel pnlMethod = new JPanel();
    private JLabel lblMethod = new JLabel();
    private JComboBox cboMethod = new JComboBox();
    private JButton btnMethod = new JButton();
    private JTextPane txtResults = new JTextPane();
    private static final long serialVersionUID = 3257853185987983152L;

    public DebugPane(Desktop desktop) {
        this.desktop = desktop;
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length != 0 || method.getDeclaringClass() != this.getClass() || !Modifier.isPublic(method.getModifiers())) continue;
            this.mdlMethods.addElement(method);
        }
        this.init();
    }

    private void init() {
        this.lblMethod.setLabelFor(this.cboMethod);
        this.lblMethod.setText(Msg.DEBUG_METHOD.toString());
        this.cboMethod.setModel(this.mdlMethods);
        this.cboMethod.setRenderer(new CustomListCellRenderer());
        this.btnMethod.setText(Msg.DEBUG_GO.toString());
        this.btnMethod.setMnemonic(Msg.DEBUG_GO.toString().charAt(0));
        this.btnMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DebugPane.this.action();
            }
        });
        this.pnlMethod.setLayout(new BorderLayout(5, 5));
        this.pnlMethod.add((Component)this.lblMethod, "West");
        this.pnlMethod.add((Component)this.cboMethod, "Center");
        this.pnlMethod.add((Component)this.btnMethod, "East");
        this.scrResults.getViewport().add(this.txtResults);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.scrResults, "Center");
        this.add((Component)this.pnlMethod, "North");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    protected void action() {
        try {
            Method method = (Method)this.cboMethod.getSelectedItem();
            Object reply = method.invoke((Object)this, new Object[0]);
            if (reply == null) {
                this.txtResults.setText("");
            } else {
                this.txtResults.setText(reply.toString());
            }
        }
        catch (Exception ex) {
            StringWriter sout = new StringWriter();
            PrintWriter out = new PrintWriter(sout);
            ex.printStackTrace(out);
            this.txtResults.setText(sout.toString());
        }
    }

    public String showViews() {
        StringBuffer reply = new StringBuffer();
        reply.append('\n');
        reply.append(Msg.DEBUG_VIEWS.toString());
        int i = 0;
        Iterator it = this.desktop.getViews().iterator();
        while (it.hasNext()) {
            BibleViewPane view = (BibleViewPane)it.next();
            reply.append(i++);
            reply.append(": ");
            reply.append(view.getTitle());
            reply.append(' ');
            reply.append(view.toString());
        }
        return reply.toString();
    }

    public void createTestJobs() {
        DebugPane.createTestJob(30000L, "test1", 20, false);
        DebugPane.createTestJob(30000L, "test2", 3, false);
        DebugPane.createTestJob(30000L, "test3", 3, true);
    }

    public static void createTestJob(final long millis, final String predictbase, final int steps, final boolean fake) {
        final URL predicturl = Project.instance().getWritablePropertiesURL(predictbase);
        Thread test = new Thread(){

            public synchronized void run() {
                Job job = JobManager.createJob((String)predictbase, (URL)predicturl, (Thread)Thread.currentThread(), (boolean)fake);
                job.setProgress(0, Msg.DEBUG_STEPS.toString(new Object[]{new Integer(0), new Integer(steps)}));
                log.debug("starting test job:");
                for (int i = 1; i <= steps && !Thread.interrupted(); ++i) {
                    try {
                        this.wait(millis / (long)steps);
                    }
                    catch (InterruptedException ex) {
                        log.warn("Exception while waiting", (Throwable)ex);
                    }
                    job.setProgress(i * 100 / steps, Msg.DEBUG_STEPS.toString(new Object[]{new Integer(i), new Integer(steps)}));
                }
                job.done();
                log.debug("finishing test job:");
            }
        };
        test.start();
    }

    public void openSplash() {
        if (this.splash == null) {
            this.splash = new Splash();
            this.splash.pack();
        }
    }

    public void closeSplash() {
        if (this.splash != null) {
            this.splash.close();
            this.splash = null;
        }
    }

    private static final class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 3257853185987983152L;

        private CustomListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Method) {
                this.setText(((Method)value).getName() + "()");
            }
            return this;
        }
    }
}

