/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookType;

public class BookListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final ImageIcon ICON_BIBLE = GuiUtil.getIcon((String)"images/book-b16.png");
    private static final ImageIcon ICON_COMNT = GuiUtil.getIcon((String)"images/book-c16.png");
    private static final ImageIcon ICON_DICT = GuiUtil.getIcon((String)"images/book-d16.png");
    private static Border noFocus = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final String PROTOTYPE_BOOK_NAME = "012345678901234567890123456789";
    private static final long serialVersionUID = 3978138859576308017L;

    public BookListCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocus);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
        if (selected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value == null) {
            this.setText(Msg.NONE.toString());
            this.setToolTipText(null);
            this.setIcon(null);
            this.setEnabled(false);
        }
        if (value instanceof String) {
            String str = (String)value;
            this.setText(str);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(focus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocus);
        }
        if (value instanceof BookMetaData) {
            Book book = (Book)value;
            String displayName = book.toString();
            this.setText(displayName);
            this.setToolTipText(displayName);
            BookType type = book.getType();
            if (type.equals((Object)BookType.BIBLE)) {
                this.setIcon(ICON_BIBLE);
            } else if (type.equals((Object)BookType.COMMENTARY)) {
                this.setIcon(ICON_COMNT);
            } else if (type.equals((Object)BookType.DICTIONARY)) {
                this.setIcon(ICON_DICT);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(focus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocus);
        }
        return this;
    }
}

