/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.crosswire.bibledesktop.passage.Msg;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.VerseRange;

public class PassageListCellRenderer
implements ListCellRenderer,
Serializable {
    private Book bible;
    private JLabel label = new JLabel();
    private Border border;
    private Map hash = new HashMap();
    private static final long serialVersionUID = 3978423624430270256L;

    public PassageListCellRenderer(Book bible) {
        this.bible = bible;
        this.border = new EmptyBorder(1, 1, 1, 1);
        this.label.setBorder(this.border);
        this.label.setOpaque(true);
        this.label.setIcon(GuiUtil.getIcon((String)"images/Passage16.gif"));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
        if (selected) {
            this.label.setBackground(list.getSelectionBackground());
            this.label.setForeground(list.getSelectionForeground());
        } else {
            this.label.setBackground(list.getBackground());
            this.label.setForeground(list.getForeground());
        }
        if (value instanceof VerseRange) {
            try {
                VerseRange range = (VerseRange)value;
                String text = (String)this.hash.get(range);
                if (text == null) {
                    BookData bdata = this.bible.getData((Key)range);
                    String simple = bdata.getPlainText();
                    text = "<html><b>" + range.getName() + "</b> " + simple;
                    this.hash.put(range, text);
                }
                this.label.setText(text);
            }
            catch (Exception ex) {
                Reporter.informUser((Object)this, (Throwable)ex);
                this.label.setText(Msg.ERROR.toString());
            }
        } else {
            this.label.setText(value == null ? "" : value.toString());
        }
        this.label.setEnabled(list.isEnabled());
        this.label.setFont(list.getFont());
        this.label.setBorder(focus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.border);
        return this.label;
    }
}

