/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageListener;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseBase;
import org.crosswire.jsword.passage.VerseRange;

final class ReadOnlyPassage
implements Passage {
    private Passage ref;
    private boolean ignore;
    private static final long serialVersionUID = 3257853173036102193L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ReadOnlyPassage(Passage ref, boolean ignore) {
        this.ref = ref;
        this.ignore = ignore;
    }

    public void addAll(Key key) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(Msg.PASSAGE_READONLY.toString());
    }

    public void removeAll(Key key) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(Msg.PASSAGE_READONLY.toString());
    }

    public void retainAll(Key key) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(Msg.PASSAGE_READONLY.toString());
    }

    public boolean contains(Key key) {
        return this.ref.contains(key);
    }

    public boolean canHaveChildren() {
        return this.ref.canHaveChildren();
    }

    public int getChildCount() {
        return this.ref.getChildCount();
    }

    public Iterator iterator() {
        return this.ref.iterator();
    }

    public Key get(int index) {
        return this.ref.get(index);
    }

    public int indexOf(Key that) {
        return this.ref.indexOf(that);
    }

    public Key getParent() {
        return this.ref.getParent();
    }

    public String getName() {
        return this.ref.getName();
    }

    public String getOSISName() {
        return this.ref.getOSISName();
    }

    public String getOverview() {
        return this.ref.getOverview();
    }

    public boolean isEmpty() {
        return this.ref.isEmpty();
    }

    public int countVerses() {
        return this.ref.countVerses();
    }

    public int countRanges(RestrictionType restrict) {
        return this.ref.countRanges(restrict);
    }

    public Passage trimVerses(int count) {
        return this.ref.trimVerses(count);
    }

    public Passage trimRanges(int count, RestrictionType restrict) {
        return this.ref.trimRanges(count, restrict);
    }

    public int booksInPassage() {
        return this.ref.booksInPassage();
    }

    public int chaptersInPassage(int book) throws NoSuchVerseException {
        return this.ref.chaptersInPassage(book);
    }

    public int versesInPassage(int book, int chapter) throws NoSuchVerseException {
        return this.ref.versesInPassage(book, chapter);
    }

    public Verse getVerseAt(int offset) throws ArrayIndexOutOfBoundsException {
        return this.ref.getVerseAt(offset);
    }

    public VerseRange getRangeAt(int offset, RestrictionType restrict) throws ArrayIndexOutOfBoundsException {
        return this.ref.getRangeAt(offset, restrict);
    }

    public Iterator rangeIterator(RestrictionType restrict) {
        return this.ref.rangeIterator(restrict);
    }

    public boolean contains(VerseBase that) {
        return this.ref.contains(that);
    }

    public void add(VerseBase that) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(Msg.PASSAGE_READONLY.toString());
    }

    public void remove(VerseBase that) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(Msg.PASSAGE_READONLY.toString());
    }

    public boolean containsAll(Passage that) {
        return this.ref.containsAll(that);
    }

    public void clear() {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(Msg.PASSAGE_READONLY.toString());
    }

    public void blur(int by, RestrictionType restrict) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(Msg.PASSAGE_READONLY.toString());
    }

    public void readDescription(Reader in) {
        if (this.ignore) {
            return;
        }
        throw new IllegalStateException(Msg.PASSAGE_READONLY.toString());
    }

    public void writeDescription(Writer out) throws IOException {
        this.ref.writeDescription(out);
    }

    public void optimizeReads() {
        this.ref.optimizeReads();
    }

    public void addPassageListener(PassageListener li) {
    }

    public void removePassageListener(PassageListener li) {
    }

    public boolean equals(Object obj) {
        return this.ref.equals(obj);
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public String toString() {
        return this.ref.toString();
    }

    public Object clone() {
        ReadOnlyPassage clone;
        block2: {
            clone = null;
            try {
                clone = (ReadOnlyPassage)super.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        clone.ref = this.ref;
        clone.ignore = this.ignore;
        return clone;
    }

    public int compareTo(Object o) {
        return this.ref.compareTo(o);
    }

    static {
        $assertionsDisabled = !ReadOnlyPassage.class.desiredAssertionStatus();
    }
}

