/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.util.Iterator;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.DefaultKeyVisitor;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;

public abstract class AbstractKeyList
implements Key {
    private String name;
    private String osisName;

    public boolean isEmpty() {
        return this.getChildCount() == 0;
    }

    public boolean contains(Key key) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Key temp = (Key)it.next();
            if (!key.equals(temp)) continue;
            return true;
        }
        return false;
    }

    public void retainAll(Key key) {
        DefaultKeyList shared = new DefaultKeyList();
        shared.addAll(key);
        AbstractKeyList.retain(this, shared);
    }

    protected static void retain(Key alter, Key base) {
        Iterator it = alter.iterator();
        while (it.hasNext()) {
            Key sublist = (Key)it.next();
            if (sublist.canHaveChildren()) {
                AbstractKeyList.retain(sublist, base);
                if (!sublist.isEmpty()) continue;
                it.remove();
                continue;
            }
            if (base.contains(sublist)) continue;
            it.remove();
        }
    }

    public String toString() {
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        final StringBuffer buffer = new StringBuffer();
        KeyUtil.visit(this, new DefaultKeyVisitor(){

            public void visitLeaf(Key key) {
                buffer.append(key.getName());
                buffer.append(", ");
            }
        });
        String reply = buffer.toString();
        if (reply.length() > 0) {
            reply = reply.substring(0, reply.length() - ", ".length());
        }
        return reply;
    }

    public String getOSISName() {
        if (this.osisName != null) {
            return this.osisName;
        }
        final StringBuffer buffer = new StringBuffer();
        KeyUtil.visit(this, new DefaultKeyVisitor(){

            public void visitLeaf(Key key) {
                buffer.append(key.getOSISName());
                buffer.append(" ");
            }
        });
        String reply = buffer.toString();
        if (reply.length() > 0) {
            reply = reply.substring(0, reply.length() - " ".length());
        }
        return reply;
    }

    public int compareTo(Object obj) {
        Key that = (Key)obj;
        Key thisfirst = (Key)this.iterator().next();
        Key thatfirst = (Key)that.iterator().next();
        if (thisfirst == null) {
            if (thatfirst == null) {
                return 0;
            }
            return 1;
        }
        if (thatfirst == null) {
            return -1;
        }
        return thisfirst.compareTo(thatfirst);
    }
}

