/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search.parse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.search.parse.DefaultWord;
import org.crosswire.jsword.book.search.parse.Msg;

public class CustomTokenizer {
    private static final int CHAR_PARAM = 0;
    private static final int CHAR_COMMAND = 1;
    private static final int CHAR_SPACE = 2;

    private CustomTokenizer() {
    }

    public static List tokenize(String sought, Map commands) throws BookException {
        ArrayList output = new ArrayList();
        String commandChars = CustomTokenizer.getSingleCharWords(commands);
        char firstChar = sought.charAt(0);
        int currentType = CustomTokenizer.charType(firstChar, commandChars);
        int startIndex = 0;
        if (sought.length() > 0 && (firstChar == '[' || firstChar == ':')) {
            sought = ' ' + sought;
        }
        for (int i = 1; i <= sought.length(); ++i) {
            int end;
            if (i != sought.length() && sought.charAt(i) == '[') {
                end = sought.indexOf(93, i);
                if (end == -1) {
                    throw new BookException(Msg.UNMATCHED_ESCAPE);
                }
                CustomTokenizer.addWord(output, commands, "[");
                CustomTokenizer.addWord(output, commands, sought.substring(i + 1, end));
                CustomTokenizer.addWord(output, commands, "]");
                currentType = 2;
                i = end + 1;
            }
            if (i != sought.length() && sought.indexOf("::", i) == i) {
                end = sought.indexOf("::", i + 2);
                if (end == -1) {
                    CustomTokenizer.addWord(output, commands, sought.substring(i + 2));
                    i = sought.length();
                } else {
                    CustomTokenizer.addWord(output, commands, sought.substring(i + 2, end));
                    i = end + 2;
                }
                currentType = 2;
            }
            if (i == sought.length()) {
                if (currentType == 2) continue;
                CustomTokenizer.addWord(output, commands, sought.substring(startIndex));
                continue;
            }
            int new_type = CustomTokenizer.charType(sought.charAt(i), commandChars);
            if (currentType == new_type && new_type != 1) continue;
            if (currentType != 2) {
                CustomTokenizer.addWord(output, commands, sought.substring(startIndex, i));
            }
            startIndex = i;
            currentType = CustomTokenizer.charType(sought.charAt(i), commandChars);
        }
        return output;
    }

    private static final int charType(char sought, String commands) {
        if (Character.isWhitespace(sought)) {
            return 2;
        }
        if (commands.indexOf(sought) != -1) {
            return 1;
        }
        return 0;
    }

    private static void addWord(List output, Map commands, String word) {
        Object wordObj = commands.get(word);
        if (wordObj == null) {
            wordObj = new DefaultWord(word);
        }
        output.add(wordObj);
    }

    private static String getSingleCharWords(Map commands) {
        Iterator it = commands.keySet().iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            String cmd = (String)it.next();
            if (cmd.length() != 1) continue;
            buf.append(cmd);
        }
        return buf.toString();
    }
}

