/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.KeyFilter;
import org.crosswire.jsword.index.lucene.analysis.SavedStreams;

public class KeyAnalyzer
extends AbstractBookAnalyzer {
    public KeyAnalyzer() {
    }

    public KeyAnalyzer(Book book) {
        this.setBook(book);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new KeyFilter(this.getBook(), (TokenStream)new KeywordTokenizer(reader));
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams((Tokenizer)new KeywordTokenizer(reader));
            streams.setResult((TokenStream)new KeyFilter(this.getBook(), streams.getResult()));
            this.setPreviousTokenStream(streams);
        } else {
            streams.getSource().reset(reader);
        }
        return streams.getResult();
    }
}

