/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.util.FileUtil;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.index.AbstractIndex;
import org.crosswire.jsword.index.IndexPolicy;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.lucene.VerseCollector;
import org.crosswire.jsword.index.lucene.analysis.LuceneAnalyzer;
import org.crosswire.jsword.index.search.SearchModifier;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseFactory;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndex
extends AbstractIndex
implements Closeable {
    public static final String FIELD_KEY = "key";
    public static final String FIELD_BODY = "content";
    public static final String FIELD_STRONG = "strong";
    public static final String FIELD_HEADING = "heading";
    public static final String FIELD_XREF = "xref";
    public static final String FIELD_NOTE = "note";
    public static final String FIELD_MORPHOLOGY = "morph";
    public static final String FIELD_INTRO = "intro";
    private static final int WORK_ESTIMATE = 98;
    private Book book;
    private String path;
    private Directory directory;
    private Searcher searcher;
    private static final Object CREATING = new Object();
    private static final Logger log = LoggerFactory.getLogger(LuceneIndex.class);

    public LuceneIndex(Book book, URI storage) throws BookException {
        this.book = book;
        try {
            this.path = NetUtil.getAsFile(storage).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new BookException(JSMsg.gettext("Failed to initialize Lucene search engine.", new Object[0]), ex);
        }
        this.initDirectoryAndSearcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneIndex(Book book, URI storage, IndexPolicy policy) throws BookException {
        this.book = book;
        File finalPath = null;
        try {
            finalPath = NetUtil.getAsFile(storage);
            this.path = finalPath.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new BookException(JSMsg.gettext("Failed to initialize Lucene search engine.", new Object[0]), ex);
        }
        String jobName = JSMsg.gettext("Creating index. Processing {0}", book.getInitials());
        Progress job = JobManager.createJob(String.format("CREATE_INDEX-%s", book.getInitials()), jobName, Thread.currentThread());
        job.beginJob(jobName);
        IndexStatus finalStatus = IndexStatus.UNDONE;
        ArrayList<Key> errors = new ArrayList<Key>();
        File tempPath = new File(this.path + '.' + IndexStatus.CREATING.toString());
        if (tempPath.exists()) {
            FileUtil.delete(tempPath);
        }
        try {
            Object mutex;
            LuceneAnalyzer analyzer = new LuceneAnalyzer(book);
            Object object = mutex = policy.isSerial() ? CREATING : book.getBookMetaData();
            synchronized (object) {
                book.setIndexStatus(IndexStatus.CREATING);
                IndexWriter writer = null;
                try {
                    FSDirectory destination = FSDirectory.open((File)new File(tempPath.getCanonicalPath()));
                    writer = new IndexWriter((Directory)destination, (Analyzer)analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
                    writer.setRAMBufferSizeMB((double)policy.getRAMBufferSize());
                    this.generateSearchIndexImpl(job, errors, writer, book.getGlobalKeyList(), 0, policy);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                job.setCancelable(false);
                if (!job.isFinished() && !tempPath.renameTo(finalPath)) {
                    throw new BookException(JSMsg.gettext("Installation failed.", new Object[0]));
                }
                if (finalPath.exists()) {
                    finalStatus = IndexStatus.DONE;
                }
                if (!errors.isEmpty()) {
                    StringBuilder buf = new StringBuilder();
                    for (Key error : errors) {
                        buf.append(error);
                        buf.append('\n');
                    }
                    Reporter.informUser((Object)this, JSMsg.gettext("The following verses have errors and could not be indexed\n{0}", buf));
                }
                this.initDirectoryAndSearcher();
            }
        }
        catch (IOException ex) {
            job.cancel();
            throw new BookException(JSMsg.gettext("Failed to initialize Lucene search engine.", new Object[0]), ex);
        }
        finally {
            book.setIndexStatus(finalStatus);
            job.done();
            if (tempPath.exists()) {
                FileUtil.delete(tempPath);
            }
        }
    }

    private void initDirectoryAndSearcher() {
        try {
            this.directory = FSDirectory.open((File)new File(this.path));
            this.searcher = new IndexSearcher(this.directory, true);
        }
        catch (IOException ex) {
            log.warn("second load failure", (Throwable)ex);
        }
    }

    @Override
    public Key find(String search) throws BookException {
        String v11nName = this.book.getBookMetaData().getProperty("Versification").toString();
        Versification v11n = Versifications.instance().getVersification(v11nName);
        SearchModifier modifier = this.getSearchModifier();
        Key results = null;
        if (search != null) {
            Throwable theCause = null;
            try {
                LuceneAnalyzer analyzer = new LuceneAnalyzer(this.book);
                QueryParser parser = new QueryParser(Version.LUCENE_29, FIELD_BODY, (Analyzer)analyzer);
                parser.setAllowLeadingWildcard(true);
                Query query = parser.parse(search);
                log.info("ParsedQuery- {}", (Object)query.toString());
                if (modifier != null && modifier.isRanked()) {
                    PassageTally tally = new PassageTally(v11n);
                    tally.raiseEventSuppresion();
                    tally.raiseNormalizeProtection();
                    results = tally;
                    TopScoreDocCollector collector = TopScoreDocCollector.create((int)modifier.getMaxResults(), (boolean)false);
                    this.searcher.search(query, (Collector)collector);
                    tally.setTotal(collector.getTotalHits());
                    ScoreDoc[] hits = collector.topDocs().scoreDocs;
                    for (int i = 0; i < hits.length; ++i) {
                        int docId = hits[i].doc;
                        Document doc = this.searcher.doc(docId);
                        Verse key = VerseFactory.fromString(v11n, doc.get(FIELD_KEY));
                        int score = (int)(hits[i].score * 100.0f + 1.0f);
                        tally.add(key, score);
                    }
                    tally.lowerNormalizeProtection();
                    tally.lowerEventSuppressionAndTest();
                } else {
                    results = this.book.createEmptyKeyList();
                    AbstractPassage passage = null;
                    if (results instanceof AbstractPassage) {
                        passage = (AbstractPassage)results;
                        passage.raiseEventSuppresion();
                        passage.raiseNormalizeProtection();
                    }
                    this.searcher.search(query, (Collector)new VerseCollector(v11n, this.searcher, results));
                    if (passage != null) {
                        passage.lowerNormalizeProtection();
                        passage.lowerEventSuppressionAndTest();
                    }
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                theCause = cause instanceof NoSuchVerseException ? cause : e;
            }
            catch (NoSuchVerseException e) {
                theCause = e;
            }
            catch (ParseException e) {
                theCause = e;
            }
            if (theCause != null) {
                throw new BookException(JSMsg.gettext("Search failed.", new Object[0]), theCause);
            }
        }
        if (results == null) {
            results = modifier != null && modifier.isRanked() ? new PassageTally(v11n) : this.book.createEmptyKeyList();
        }
        return results;
    }

    @Override
    public Key getKey(String name) throws NoSuchKeyException {
        return this.book.getKey(name);
    }

    @Override
    public final void close() {
        IOUtil.close((Closeable)this.searcher);
        this.searcher = null;
        IOUtil.close((Closeable)this.directory);
        this.directory = null;
    }

    private void generateSearchIndexImpl(Progress job, List<Key> errors, IndexWriter writer, Key key, int count, IndexPolicy policy) throws BookException, IOException {
        String v11nName = null;
        if (this.book.getBookMetaData().getProperty("Versification") != null) {
            v11nName = this.book.getBookMetaData().getProperty("Versification").toString();
        }
        Versification v11n = Versifications.instance().getVersification(v11nName);
        boolean includeStrongs = this.book.getBookMetaData().hasFeature(FeatureType.STRONGS_NUMBERS) && policy.isStrongsIndexed();
        boolean includeXrefs = this.book.getBookMetaData().hasFeature(FeatureType.SCRIPTURE_REFERENCES) && policy.isXrefIndexed();
        boolean includeNotes = this.book.getBookMetaData().hasFeature(FeatureType.FOOTNOTES) && policy.isNoteIndexed();
        boolean includeHeadings = this.book.getBookMetaData().hasFeature(FeatureType.HEADINGS) && policy.isTitleIndexed();
        boolean includeMorphology = this.book.getBookMetaData().hasFeature(FeatureType.MORPHOLOGY) && policy.isMorphIndexed();
        String oldRootName = "";
        int percent = 0;
        String rootName = "";
        BookData data = null;
        Element osis = null;
        Document doc = new Document();
        Field keyField = new Field(FIELD_KEY, "", Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO);
        Field bodyField = new Field(FIELD_BODY, "", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
        Field introField = new Field(FIELD_INTRO, "", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
        Field strongField = new Field(FIELD_STRONG, "", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES);
        Field xrefField = new Field(FIELD_XREF, "", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
        Field noteField = new Field(FIELD_NOTE, "", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
        Field headingField = new Field(FIELD_HEADING, "", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
        Field morphologyField = new Field(FIELD_MORPHOLOGY, "", Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
        int size = key.getCardinality();
        int subCount = count;
        log.debug("Number of keys = {}", (Object)Integer.toString(size));
        for (Key subkey : key) {
            int oldPercent;
            if (subkey.canHaveChildren()) {
                this.generateSearchIndexImpl(job, errors, writer, subkey, subCount, policy);
                continue;
            }
            data = new BookData(this.book, subkey);
            osis = null;
            try {
                osis = data.getOsisFragment(false);
            }
            catch (BookException e) {
                errors.add(subkey);
                continue;
            }
            doc.getFields().clear();
            keyField.setValue(subkey.getOsisRef());
            doc.add((Fieldable)keyField);
            if (subkey instanceof Verse && ((Verse)subkey).getVerse() == 0) {
                this.addField(doc, introField, OSISUtil.getCanonicalText(osis));
            } else {
                this.addField(doc, bodyField, OSISUtil.getCanonicalText(osis));
            }
            if (includeStrongs) {
                this.addField(doc, strongField, OSISUtil.getStrongsNumbers(osis));
            }
            if (includeXrefs) {
                this.addField(doc, xrefField, OSISUtil.getReferences(this.book, subkey, v11n, osis));
            }
            if (includeNotes) {
                this.addField(doc, noteField, OSISUtil.getNotes(osis));
            }
            if (includeHeadings) {
                String heading = OSISUtil.getHeadings(osis);
                this.addField(doc, headingField, heading);
            }
            if (includeMorphology) {
                this.addField(doc, morphologyField, OSISUtil.getMorphologiesWithStrong(osis));
            }
            if (doc.getFields().size() > 1) {
                writer.addDocument(doc);
            }
            if (!(rootName = subkey.getRootName()).equals(oldRootName)) {
                oldRootName = rootName;
                job.setSectionName(rootName);
            }
            if ((oldPercent = percent) != (percent = 98 * ++subCount / size)) {
                job.setWork(percent);
            }
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
    }

    private void addField(Document doc, Field field, String text) {
        if (text != null && text.length() > 0) {
            field.setValue(text);
            doc.add((Fieldable)field);
        }
    }

    public Searcher getSearcher() {
        return this.searcher;
    }
}

