/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.crosswire.common.util.Filter;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.IniSection;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.KeyType;
import org.crosswire.jsword.book.MetaDataLocator;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.book.filter.SourceFilter;
import org.crosswire.jsword.book.filter.SourceFilterFactory;
import org.crosswire.jsword.book.sword.BookType;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwordBookMetaData
extends AbstractBookMetaData {
    public static final String KEY_ABBREVIATION = "Abbreviation";
    public static final String KEY_ABOUT = "About";
    public static final String KEY_BLOCK_COUNT = "BlockCount";
    public static final String KEY_BLOCK_TYPE = "BlockType";
    public static final String KEY_CASE_SENSITIVE_KEYS = "CaseSensitiveKeys";
    public static final String KEY_CIPHER_KEY = "CipherKey";
    public static final String KEY_COMPRESS_TYPE = "CompressType";
    public static final String KEY_COPYRIGHT = "Copyright";
    public static final String KEY_COPYRIGHT_CONTACT_ADDRESS = "CopyrightContactAddress";
    public static final String KEY_COPYRIGHT_CONTACT_EMAIL = "CopyrightContactEmail";
    public static final String KEY_COPYRIGHT_CONTACT_NAME = "CopyrightContactName";
    public static final String KEY_COPYRIGHT_CONTACT_NOTES = "CopyrightContactNotes";
    public static final String KEY_COPYRIGHT_DATE = "CopyrightDate";
    public static final String KEY_COPYRIGHT_HOLDER = "CopyrightHolder";
    public static final String KEY_COPYRIGHT_NOTES = "CopyrightNotes";
    public static final String KEY_DATA_PATH = "DataPath";
    public static final String KEY_DESCRIPTION = "Description";
    public static final String KEY_DIRECTION = "Direction";
    public static final String KEY_DISPLAY_LEVEL = "DisplayLevel";
    public static final String KEY_DISTRIBUTION_LICENSE = "DistributionLicense";
    public static final String KEY_DISTRIBUTION_NOTES = "DistributionNotes";
    public static final String KEY_DISTRIBUTION_SOURCE = "DistributionSource";
    public static final String KEY_ENCODING = "Encoding";
    public static final String KEY_FEATURE = "Feature";
    public static final String KEY_GLOBAL_OPTION_FILTER = "GlobalOptionFilter";
    public static final String KEY_SIGLUM1 = "Siglum1";
    public static final String KEY_SIGLUM2 = "Siglum2";
    public static final String KEY_SIGLUM3 = "Siglum3";
    public static final String KEY_SIGLUM4 = "Siglum4";
    public static final String KEY_SIGLUM5 = "Siglum5";
    public static final String KEY_GLOSSARY_FROM = "GlossaryFrom";
    public static final String KEY_GLOSSARY_TO = "GlossaryTo";
    public static final String KEY_HISTORY = "History";
    public static final String KEY_INSTALL_SIZE = "InstallSize";
    public static final String KEY_KEY_TYPE = "KeyType";
    public static final String KEY_LCSH = "LCSH";
    public static final String KEY_LOCAL_STRIP_FILTER = "LocalStripFilter";
    public static final String KEY_MINIMUM_VERSION = "MinimumVersion";
    public static final String KEY_MOD_DRV = "ModDrv";
    public static final String KEY_OBSOLETES = "Obsoletes";
    public static final String KEY_OSIS_Q_TO_TICK = "OSISqToTick";
    public static final String KEY_OSIS_VERSION = "OSISVersion";
    public static final String KEY_PREFERRED_CSS_XHTML = "PreferredCSSXHTML";
    public static final String KEY_SEARCH_OPTION = "SearchOption";
    public static final String KEY_SHORT_COPYRIGHT = "ShortCopyright";
    public static final String KEY_SHORT_PROMO = "ShortPromo";
    public static final String KEY_SOURCE_TYPE = "SourceType";
    public static final String KEY_STRONGS_PADDING = "StrongsPadding";
    public static final String KEY_SWORD_VERSION_DATE = "SwordVersionDate";
    public static final String KEY_TEXT_SOURCE = "TextSource";
    public static final String KEY_UNLOCK_URL = "UnlockURL";
    public static final String KEY_VERSION = "Version";
    public static final Map<String, String> DEFAULTS;
    private boolean installed;
    private boolean filtered;
    private String bookConf;
    private IniSection configAll;
    private IniSection configJSword;
    private IniSection configFrontend;
    private boolean supported;
    private BookCategory bookCat;
    private BookType bookType;
    private boolean questionable;
    private File configFile;
    private static final String[] REQUIRED;
    private static boolean partialLoading;
    private static Filter keyKeepers;
    private static final String[] OSIS_INFO;
    private static final String[] HIDDEN;
    private static final Pattern RTF_PATTERN;
    private static final Pattern HTML_PATTERN;
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String ENCODING_LATIN1 = "WINDOWS-1252";
    private static final PropertyMap ENCODING_JAVA;
    private static final Logger LOGGER;

    public SwordBookMetaData(File file, URI bookRootPath) throws IOException, BookException {
        this.installed = true;
        this.configFile = file;
        this.bookConf = file.getName();
        this.setLibrary(bookRootPath);
        this.configAll = new IniSection();
        this.filtered = true;
        this.reload(keyKeepers);
    }

    public SwordBookMetaData(byte[] buffer, String bookConf) throws IOException, BookException {
        this.installed = false;
        this.bookConf = bookConf;
        this.supported = true;
        this.configAll = new IniSection();
        this.filtered = true;
        this.loadBuffer(buffer, keyKeepers);
        this.adjustConfig();
        SwordBookMetaData.report(this.configAll);
    }

    @Override
    public void reload() throws BookException {
        this.reload(null);
    }

    public void reload(Filter<String> keepers) throws BookException {
        if (!this.filtered && keepers == null) {
            return;
        }
        this.supported = true;
        if (this.configJSword != null) {
            this.configJSword.clear();
        }
        if (this.configFrontend != null) {
            this.configFrontend.clear();
        }
        try {
            if (this.installed) {
                this.loadFile(keepers);
            } else {
                byte[] buffer = IOUtil.getZipEntry(this.bookConf);
                this.loadBuffer(buffer, keepers);
            }
            this.adjustConfig();
            SwordBookMetaData.report(this.configAll);
            this.configJSword = this.addConfig(MetaDataLocator.JSWORD);
            this.configFrontend = this.addConfig(MetaDataLocator.FRONTEND);
        }
        catch (IOException ex) {
            throw new BookException("unable to load conf", ex);
        }
    }

    @Override
    public boolean isQuestionable() {
        return this.questionable;
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    @Override
    public boolean isEnciphered() {
        String cipher = this.getProperty(KEY_CIPHER_KEY);
        return cipher != null;
    }

    @Override
    public boolean isLocked() {
        String cipher = this.getProperty(KEY_CIPHER_KEY);
        return cipher != null && cipher.length() == 0;
    }

    @Override
    public boolean unlock(String unlockKey) {
        this.putProperty(KEY_CIPHER_KEY, unlockKey, false);
        return true;
    }

    @Override
    public String getUnlockKey() {
        return this.getProperty(KEY_CIPHER_KEY);
    }

    @Override
    public String getName() {
        return this.getProperty(KEY_DESCRIPTION);
    }

    @Override
    public String getBookCharset() {
        return ENCODING_JAVA.get(this.getProperty(KEY_ENCODING));
    }

    @Override
    public KeyType getKeyType() {
        BookType bt = this.getBookType();
        if (bt == null) {
            return null;
        }
        return bt.getKeyType();
    }

    public BookType getBookType() {
        return this.bookType;
    }

    public SourceFilter getFilter() {
        String sourcetype = this.getProperty(KEY_SOURCE_TYPE);
        return SourceFilterFactory.getFilter(sourcetype);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public BookCategory getBookCategory() {
        if (this.bookCat == null) {
            this.bookCat = (BookCategory)((Object)this.getValue("Category"));
            if (this.bookCat == BookCategory.OTHER) {
                BookType bt = this.getBookType();
                if (bt == null) {
                    return this.bookCat;
                }
                this.bookCat = bt.getBookCategory();
            }
        }
        return this.bookCat;
    }

    @Override
    public Document toOSIS() {
        ArrayList<String> knownKeys = new ArrayList<String>(this.configAll.getKeys());
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element table = factory.createTable();
        Element row = this.toRow(factory, "Initials", this.getInitials());
        table.addContent((Content)row);
        for (String key : OSIS_INFO) {
            knownKeys.remove(key);
            row = this.toRow(factory, key);
            if (row == null) continue;
            table.addContent((Content)row);
        }
        List<String> hide = Arrays.asList(HIDDEN);
        for (String key : knownKeys) {
            if (hide.contains(key) || (row = this.toRow(factory, key)) == null) continue;
            table.addContent((Content)row);
        }
        return new Document(table);
    }

    public static void normalize(Writer out, IniSection config, String[] order) {
        PrintWriter writer = null;
        writer = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        IniSection copy = new IniSection(config);
        SwordBookMetaData.adjustHistory(copy);
        ArrayList<String> knownKeys = new ArrayList<String>(copy.getKeys());
        writer.print("[");
        writer.print(copy.getName());
        writer.print("]");
        writer.println();
        for (String key : order) {
            knownKeys.remove(key);
            if (!copy.containsKey(key)) continue;
            Collection<String> values = copy.getValues(key);
            for (String value : values) {
                String newKey = key;
                if (KEY_HISTORY.equalsIgnoreCase(key)) {
                    int pos = value.indexOf(32);
                    newKey = newKey + '_' + value.substring(0, pos);
                    value = value.substring(pos + 1);
                }
                writer.print(newKey);
                writer.print("=");
                writer.print(value.replaceAll("\n", " \\\\\n"));
                writer.println();
            }
        }
        for (String key : knownKeys) {
            Collection<String> values = copy.getValues(key);
            for (String value : values) {
                writer.print(key);
                writer.print("=");
                writer.print(value.replaceAll("\n", " \\\\\n"));
                writer.println();
            }
        }
        writer.flush();
    }

    @Override
    public String getInitials() {
        return this.configAll.getName();
    }

    String getInternalName() {
        return this.configAll.getName();
    }

    @Override
    public String getAbbreviation() {
        String abbreviation = this.getProperty(KEY_ABBREVIATION);
        if (abbreviation != null && abbreviation.length() > 0) {
            return abbreviation;
        }
        return this.getInitials();
    }

    @Override
    public boolean isLeftToRight() {
        String dir = this.getProperty(KEY_DIRECTION);
        if ("bidi".equalsIgnoreCase(dir)) {
            Language lang = this.getLanguage();
            return lang.isLeftToRight();
        }
        return "LtoR".equalsIgnoreCase(dir);
    }

    @Override
    public boolean hasFeature(FeatureType feature) {
        String name = feature.toString();
        if (this.configAll.containsValue(KEY_FEATURE, name)) {
            return true;
        }
        StringBuilder buffer = new StringBuilder(this.getProperty(KEY_SOURCE_TYPE));
        buffer.append(name);
        if (this.configAll.containsValue(KEY_GLOBAL_OPTION_FILTER, buffer.toString())) {
            return true;
        }
        String alias = feature.getAlias();
        buffer.setLength(0);
        buffer.append(this.getProperty(KEY_SOURCE_TYPE));
        buffer.append(alias);
        return this.configAll.containsValue(KEY_GLOBAL_OPTION_FILTER, name) || this.configAll.containsValue(KEY_GLOBAL_OPTION_FILTER, buffer.toString());
    }

    @Override
    public Set<String> getPropertyKeys() {
        return null;
    }

    @Override
    public String getProperty(String key) {
        if ("Language".equals(key)) {
            return this.getLanguage().getName();
        }
        return this.configAll.get(key, DEFAULTS.get(key));
    }

    @Override
    public void setProperty(String key, String value) {
        this.configAll.replace(key, value);
    }

    @Override
    public void putProperty(String key, String value, boolean forFrontend) {
        MetaDataLocator mdl = forFrontend ? MetaDataLocator.FRONTEND : MetaDataLocator.JSWORD;
        this.putProperty(key, value, mdl);
    }

    public void putProperty(String key, String value, MetaDataLocator metaDataLocator) {
        this.setProperty(key, value);
        if (!this.installed) {
            return;
        }
        File writeLocation = metaDataLocator.getWriteLocation();
        if (writeLocation == null) {
            return;
        }
        IniSection config = null;
        switch (metaDataLocator) {
            case FRONTEND: {
                if (this.configFrontend == null) {
                    this.configFrontend = new IniSection(this.configAll.getName());
                }
                config = this.configFrontend;
                break;
            }
            case JSWORD: {
                if (this.configJSword == null) {
                    this.configJSword = new IniSection(this.configAll.getName());
                }
                config = this.configJSword;
                break;
            }
        }
        if (config != null) {
            config.replace(key, value);
            try {
                config.save(new File(writeLocation, this.bookConf), this.getBookCharset());
            }
            catch (IOException ex) {
                LOGGER.error("Unable to save {}={}: conf file for [{}]; error={}", new Object[]{key, value, this.configAll.getName(), ex});
            }
        }
    }

    public static void setPartialLoading(boolean partial) {
        if (partial != partialLoading) {
            keyKeepers = partial ? new KeyFilter(REQUIRED) : null;
        }
        partialLoading = partial;
    }

    private void loadFile(Filter<String> keepers) throws IOException {
        this.filtered = keepers != null;
        this.configAll.clear();
        this.configAll.load(this.configFile, ENCODING_UTF8, keepers);
        String encoding = this.configAll.get(KEY_ENCODING);
        if (!ENCODING_UTF8.equalsIgnoreCase(encoding)) {
            this.configAll.clear();
            this.configAll.load(this.configFile, ENCODING_LATIN1, keepers);
        }
    }

    private void loadBuffer(byte[] buffer, Filter<String> keepers) throws IOException {
        this.filtered = keepers != null;
        this.configAll.clear();
        this.configAll.load(buffer, ENCODING_UTF8, keepers);
        String encoding = this.configAll.get(KEY_ENCODING);
        if (!ENCODING_UTF8.equalsIgnoreCase(encoding)) {
            this.configAll.clear();
            this.configAll.load(buffer, ENCODING_LATIN1, keepers);
        }
    }

    private IniSection addConfig(MetaDataLocator locator) {
        File conf = new File(locator.getWriteLocation(), this.bookConf);
        if (!conf.exists()) {
            conf = new File(locator.getReadLocation(), this.bookConf);
        }
        if (conf.exists()) {
            String encoding = this.getProperty(KEY_ENCODING);
            try {
                IniSection config = new IniSection();
                config.load(conf, encoding);
                this.mergeConfig(config);
                return config;
            }
            catch (IOException e) {
                LOGGER.error("Unable to load conf {}:{}", (Object)conf, (Object)e);
            }
        }
        return null;
    }

    private void mergeConfig(IniSection config) {
        for (String key : config.getKeys()) {
            ConfigEntryType type = ConfigEntryType.fromString(key);
            for (String value : config.getValues(key)) {
                if (type != null && type.mayRepeat()) {
                    if (this.configAll.containsValue(key, value)) continue;
                    this.configAll.add(key, value);
                    continue;
                }
                this.setProperty(key, value);
            }
        }
    }

    private Object getValue(String key) {
        ConfigEntryType type = ConfigEntryType.fromString(key);
        String ce = this.getProperty(key);
        if (type == null) {
            return ce;
        }
        return ce == null ? null : type.convert(ce);
    }

    private Element toRow(OSISUtil.OSISFactory factory, String key, String value) {
        Element nameEle = this.toKeyCell(factory, key);
        Element valueElement = factory.createCell();
        valueElement.addContent(value);
        Element rowEle = factory.createRow();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        return rowEle;
    }

    private Element toRow(OSISUtil.OSISFactory factory, String key) {
        int size = this.configAll.size(key);
        if (size == 0) {
            return null;
        }
        ConfigEntryType type = ConfigEntryType.fromString(key);
        Element nameEle = this.toKeyCell(factory, key);
        Element valueElement = factory.createCell();
        for (int j = 0; j < size; ++j) {
            if (j > 0) {
                valueElement.addContent((Content)factory.createLB());
            }
            String text = this.configAll.get(key, j);
            if (type != null && !type.isText() && type.isAllowed(text)) {
                text = type.convert(text).toString();
            }
            text = XMLUtil.escape(text);
            if (type != null && type.allowsRTF()) {
                valueElement.addContent(OSISUtil.rtfToOsis(text));
                continue;
            }
            valueElement.addContent(text);
        }
        Element rowEle = factory.createRow();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        return rowEle;
    }

    private Element toKeyCell(OSISUtil.OSISFactory factory, String key) {
        Element nameEle = factory.createCell();
        Element hiEle = factory.createHI();
        hiEle.setAttribute("type", "bold");
        nameEle.addContent((Content)hiEle);
        hiEle.addContent(key);
        return nameEle;
    }

    private void adjustConfig() throws BookException {
        this.adjustLocation();
        this.adjustLanguage();
        this.adjustBookType();
        this.adjustName();
        SwordBookMetaData.adjustHistory(this.configAll);
    }

    private void adjustLanguage() {
        String lang = this.getProperty("Lang");
        this.testLanguage("Lang", lang);
        String langFrom = this.configAll.get(KEY_GLOSSARY_FROM);
        String langTo = this.configAll.get(KEY_GLOSSARY_TO);
        if (langFrom != null || langTo != null) {
            if (langFrom == null) {
                langFrom = lang;
                this.setProperty(KEY_GLOSSARY_FROM, langFrom);
                LOGGER.warn("Missing data for [{}]. Assuming {}={}", new Object[]{this.configAll.getName(), KEY_GLOSSARY_FROM, langFrom});
            }
            this.testLanguage(KEY_GLOSSARY_FROM, langFrom);
            if (langTo == null) {
                langTo = Language.DEFAULT_LANG.getGivenSpecification();
                this.setProperty(KEY_GLOSSARY_TO, langTo);
                LOGGER.warn("Missing data for [{}]. Assuming {}={}", new Object[]{this.configAll.getName(), KEY_GLOSSARY_TO, langTo});
            }
            this.testLanguage(KEY_GLOSSARY_TO, langTo);
            if (!langFrom.equals(lang) && !langTo.equals(lang)) {
                LOGGER.error("Data error in [{}]. Neither {} or {} match {}", new Object[]{this.configAll.getName(), KEY_GLOSSARY_FROM, KEY_GLOSSARY_TO, "Lang"});
            }
        }
        this.setLanguage((Language)this.getValue("Lang"));
    }

    private void testLanguage(String key, String lang) {
        Language language = new Language(lang);
        if (!language.isValidLanguage()) {
            LOGGER.warn("Unknown language [{}]{}={}", new Object[]{this.configAll.getName(), key, lang});
        }
    }

    private void adjustBookType() {
        BookCategory focusedCategory = (BookCategory)((Object)this.getValue("Category"));
        this.questionable = focusedCategory == BookCategory.QUESTIONABLE;
        String modTypeName = this.getProperty(KEY_MOD_DRV);
        if (modTypeName == null) {
            LOGGER.error("Book not supported: malformed conf file for [{}] no {} found.", (Object)this.configAll.getName(), (Object)KEY_MOD_DRV);
            this.supported = false;
            return;
        }
        String v11n = this.getProperty("Versification");
        if (!Versifications.instance().isDefined(v11n)) {
            LOGGER.error("Book not supported: Unknown versification for [{}]{}={}.", new Object[]{this.configAll.getName(), "Versification", v11n});
            this.supported = false;
            return;
        }
        this.bookType = BookType.fromString(modTypeName);
        if (this.bookType == null) {
            LOGGER.error("Book not supported: malformed conf file for [{}] no book type found", (Object)this.configAll.getName());
            this.supported = false;
            return;
        }
        if (focusedCategory == BookCategory.OTHER) {
            focusedCategory = this.bookType.getBookCategory();
        }
        this.setProperty("Category", focusedCategory.getName());
    }

    private void adjustName() {
        if (this.configAll.get(KEY_DESCRIPTION) == null) {
            LOGGER.error("Malformed conf file: missing [{}]{}=. Using {}", new Object[]{this.configAll.getName(), KEY_DESCRIPTION, this.configAll.getName()});
            this.setProperty(KEY_DESCRIPTION, this.configAll.getName());
        }
    }

    private void adjustLocation() throws BookException {
        URI location;
        File bookDir;
        URI library = this.getLibrary();
        if (library == null) {
            return;
        }
        String datapath = this.getProperty(KEY_DATA_PATH);
        int lastSlash = datapath.lastIndexOf(47);
        if (lastSlash == -1) {
            return;
        }
        boolean isDirectoryPath = false;
        if (lastSlash == datapath.length() - 1) {
            isDirectoryPath = true;
            datapath = datapath.substring(0, lastSlash);
        }
        if (!(bookDir = new File((location = NetUtil.lengthenURI(library, datapath)).getPath())).isDirectory()) {
            if (isDirectoryPath) {
                throw new BookException(JSMsg.gettext("The book {0} is missing its data files", this.configAll.getName()));
            }
            if (!new File(location.getPath() + ".dat").exists()) {
                throw new BookException(JSMsg.gettext("The book {0} is missing its data files", this.configAll.getName()));
            }
            lastSlash = datapath.lastIndexOf(47);
            datapath = datapath.substring(0, lastSlash);
            location = NetUtil.lengthenURI(library, datapath);
        }
        this.setLocation(location);
    }

    private static void adjustHistory(IniSection config) {
        ArrayList<String> keys = new ArrayList<String>(config.getKeys());
        for (String key : keys) {
            String value = config.get(key);
            ConfigEntryType type = ConfigEntryType.fromString(key);
            if (!ConfigEntryType.HISTORY.equals((Object)type)) continue;
            config.remove(key);
            int pos = key.indexOf(95);
            value = key.substring(pos + 1) + ' ' + value;
            config.add(KEY_HISTORY, value);
        }
    }

    public static void report(IniSection config) {
        StringBuilder buf = new StringBuilder(config.report());
        for (String key : config.getKeys()) {
            ConfigEntryType type = ConfigEntryType.fromString(key);
            if (type == null && key.contains("_")) {
                String baseKey = key.substring(0, key.indexOf(95));
                type = ConfigEntryType.fromString(baseKey);
            }
            int count = config.size(key);
            for (int i = 0; i < count; ++i) {
                String value = config.get(key, i);
                if (type == null) {
                    buf.append("Unknown entry: ").append(key).append(" = ").append(value).append('\n');
                    continue;
                }
                if (value.length() == 0 && type != ConfigEntryType.CIPHER_KEY) {
                    buf.append("Unexpected empty entry: ").append(key).append(" = ").append(value).append('\n');
                    continue;
                }
                value = type.filter(value);
                if (!type.allowsRTF() && RTF_PATTERN.matcher(value).find()) {
                    buf.append("Unexpected RTF: ").append(key).append(" = ").append(value).append('\n');
                }
                if (!type.allowsHTML() && HTML_PATTERN.matcher(value).find()) {
                    buf.append("Unexpected HTML: ").append(key).append(" = ").append(value).append('\n');
                }
                if (!type.isAllowed(value)) {
                    buf.append("Unknown config value: ").append(key).append(" = ").append(value).append('\n');
                }
                if (count <= 1 || type.mayRepeat()) continue;
                buf.append("Unexpected repeated config key: ").append(key).append(" = ").append(value).append('\n');
            }
        }
        if (buf.length() > 0) {
            LOGGER.info("Conf report for [{}]\n{}", (Object)config.getName(), (Object)buf.toString());
        }
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(KEY_COMPRESS_TYPE, "LZSS");
        tempMap.put(KEY_BLOCK_TYPE, "CHAPTER");
        tempMap.put(KEY_BLOCK_COUNT, "200");
        tempMap.put(KEY_KEY_TYPE, "TreeKey");
        tempMap.put("Versification", "KJV");
        tempMap.put(KEY_DIRECTION, "LtoR");
        tempMap.put(KEY_SOURCE_TYPE, "Plaintext");
        tempMap.put(KEY_ENCODING, "Latin-1");
        tempMap.put(KEY_DISPLAY_LEVEL, "1");
        tempMap.put(KEY_OSIS_Q_TO_TICK, "true");
        tempMap.put(KEY_VERSION, "1.0");
        tempMap.put(KEY_MINIMUM_VERSION, "1.5.1a");
        tempMap.put("Category", "Other");
        tempMap.put("Lang", "en");
        tempMap.put(KEY_DISTRIBUTION_LICENSE, "Public Domain");
        tempMap.put(KEY_CASE_SENSITIVE_KEYS, "false");
        tempMap.put(KEY_STRONGS_PADDING, "true");
        DEFAULTS = Collections.unmodifiableMap(tempMap);
        REQUIRED = new String[]{KEY_ABBREVIATION, KEY_DESCRIPTION, "Lang", "Category", KEY_VERSION, KEY_FEATURE, KEY_GLOBAL_OPTION_FILTER, KEY_SIGLUM1, KEY_SIGLUM2, KEY_SIGLUM3, KEY_SIGLUM4, KEY_SIGLUM5, "Font", KEY_DATA_PATH, KEY_MOD_DRV, KEY_SOURCE_TYPE, KEY_BLOCK_TYPE, KEY_BLOCK_COUNT, KEY_COMPRESS_TYPE, KEY_ENCODING, KEY_DIRECTION, KEY_KEY_TYPE, KEY_DISPLAY_LEVEL, "Versification", KEY_CASE_SENSITIVE_KEYS, KEY_LOCAL_STRIP_FILTER, KEY_PREFERRED_CSS_XHTML, KEY_STRONGS_PADDING, KEY_SEARCH_OPTION, KEY_INSTALL_SIZE, "Scope", "BookList", KEY_CIPHER_KEY};
        OSIS_INFO = new String[]{KEY_ABBREVIATION, KEY_DESCRIPTION, "Lang", "Category", KEY_LCSH, KEY_SWORD_VERSION_DATE, KEY_VERSION, KEY_HISTORY, KEY_OBSOLETES, KEY_GLOSSARY_FROM, KEY_GLOSSARY_TO, KEY_ABOUT, KEY_SHORT_PROMO, KEY_DISTRIBUTION_LICENSE, KEY_DISTRIBUTION_NOTES, KEY_DISTRIBUTION_SOURCE, KEY_SHORT_COPYRIGHT, KEY_COPYRIGHT, KEY_COPYRIGHT_DATE, KEY_COPYRIGHT_HOLDER, KEY_COPYRIGHT_CONTACT_NAME, KEY_COPYRIGHT_CONTACT_ADDRESS, KEY_COPYRIGHT_CONTACT_EMAIL, KEY_COPYRIGHT_CONTACT_NOTES, KEY_COPYRIGHT_NOTES, KEY_TEXT_SOURCE, KEY_FEATURE, KEY_GLOBAL_OPTION_FILTER, KEY_SIGLUM1, KEY_SIGLUM2, KEY_SIGLUM3, KEY_SIGLUM4, KEY_SIGLUM5, "Font", KEY_DATA_PATH, KEY_MOD_DRV, KEY_SOURCE_TYPE, KEY_BLOCK_TYPE, KEY_BLOCK_COUNT, KEY_COMPRESS_TYPE, KEY_ENCODING, KEY_MINIMUM_VERSION, KEY_OSIS_VERSION, KEY_OSIS_Q_TO_TICK, KEY_DIRECTION, KEY_KEY_TYPE, KEY_DISPLAY_LEVEL, "Versification", KEY_CASE_SENSITIVE_KEYS, KEY_LOCAL_STRIP_FILTER, KEY_PREFERRED_CSS_XHTML, KEY_STRONGS_PADDING, KEY_SEARCH_OPTION, KEY_INSTALL_SIZE, "Scope", "BookList"};
        HIDDEN = new String[]{KEY_CIPHER_KEY, "Language"};
        RTF_PATTERN = Pattern.compile("\\\\pard|\\\\pa[er]|\\\\qc|\\\\[bi]|\\\\u-?[0-9]{4,6}+");
        HTML_PATTERN = Pattern.compile("(<[a-zA-Z]|[a-zA-Z]>)");
        ENCODING_JAVA = new PropertyMap();
        ENCODING_JAVA.put("Latin-1", ENCODING_LATIN1);
        ENCODING_JAVA.put(ENCODING_UTF8, ENCODING_UTF8);
        LOGGER = LoggerFactory.getLogger(SwordBookMetaData.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyFilter
    implements Filter<String> {
        private Set keepers = new HashSet();

        KeyFilter(String[] keepers) {
            for (String key : keepers) {
                this.keepers.add(key);
            }
        }

        @Override
        public boolean test(String key) {
            return this.keepers.contains(key);
        }
    }
}

