/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.state.OpenFileState;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.RestrictionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyBackend<T extends OpenFileState>
extends AbstractBackend<T>
implements Key {
    private static final long serialVersionUID = -2782112117361556089L;

    public AbstractKeyBackend(SwordBookMetaData sbmd) {
        super(sbmd);
    }

    @Override
    public boolean canHaveChildren() {
        return false;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getCardinality() == 0;
    }

    @Override
    public boolean contains(Key key) {
        return this.indexOf(key) >= 0;
    }

    @Override
    public Iterator<Key> iterator() {
        return new Iterator<Key>(){
            private int here;
            private int count;
            {
                this.count = AbstractKeyBackend.this.getCardinality();
            }

            @Override
            public boolean hasNext() {
                return this.here < this.count;
            }

            @Override
            public Key next() throws NoSuchElementException {
                if (this.here >= this.count) {
                    throw new NoSuchElementException();
                }
                return AbstractKeyBackend.this.get(this.here++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void addAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAliasKey(T state, Key alias, Key source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawText(T state, Key key, String text) throws BookException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Key getParent() {
        return null;
    }

    @Override
    public AbstractKeyBackend<T> clone() {
        AbstractKeyBackend clone;
        block2: {
            clone = null;
            try {
                clone = (AbstractKeyBackend)super.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return clone;
    }

    @Override
    public String getName() {
        return this.getBookMetaData().getInitials();
    }

    @Override
    public String getName(Key base) {
        return this.getName();
    }

    @Override
    public String getOsisID() {
        return this.getName();
    }

    @Override
    public String getOsisRef() {
        return this.getName();
    }

    @Override
    public String getRootName() {
        return this.getName();
    }

    @Override
    public void retainAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.compareTo((Key)obj) == 0;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(Key that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        int ret = this.getName().compareTo(that.getName());
        if (ret != 0) {
            return ret;
        }
        Iterator<Key> thisIter = this.iterator();
        Iterator thatIter = that.iterator();
        Key thisfirst = null;
        Key thatfirst = null;
        if (thisIter.hasNext()) {
            thisfirst = thisIter.next();
        }
        if (thatIter.hasNext()) {
            thatfirst = (Key)thatIter.next();
        }
        if (thisfirst == null) {
            if (thatfirst == null) {
                return 0;
            }
            return 1;
        }
        if (thatfirst == null) {
            return -1;
        }
        return thisfirst.getName().compareTo(thatfirst.getName());
    }

    @Override
    public void blur(int by, RestrictionType restrict) {
    }
}

