/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.icu;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateFormatter {
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(DateFormatter.class);
    private static final String DEFAULT_SIMPLE_DATE_FORMAT_CLASS = "com.ibm.icu.text.SimpleDateFormat";
    private static final String DEFAULT_DATE_FORMAT_CLASS = "com.ibm.icu.text.DateFormat";
    private Object formatter;
    private Class<?> formatterClass;
    private static Class<?> defaultSimpleDateFormat;
    private static Class<?> defaultDateFormat;

    private DateFormatter() {
    }

    public static DateFormatter getDateInstance(int format) {
        DateFormatter fmt = new DateFormatter();
        boolean oops = false;
        try {
            fmt.formatterClass = defaultDateFormat;
            Class[] instanceTypes = new Class[]{Integer.TYPE};
            Object[] instanceParams = new Object[]{format};
            fmt.formatter = ReflectionUtil.invoke(fmt.formatterClass, fmt.formatterClass, "getDateInstance", instanceParams, instanceTypes);
        }
        catch (NoSuchMethodException e) {
            oops = true;
        }
        catch (IllegalAccessException e) {
            oops = true;
        }
        catch (InvocationTargetException e) {
            oops = true;
        }
        catch (NullPointerException e) {
            oops = true;
        }
        if (oops) {
            fmt.formatterClass = DateFormat.class;
            fmt.formatter = DateFormat.getDateInstance(format);
        }
        return fmt;
    }

    public static DateFormatter getDateInstance() {
        return DateFormatter.getDateInstance(2);
    }

    public static DateFormatter getSimpleDateInstance(String format) {
        DateFormatter fmt = new DateFormatter();
        boolean oops = false;
        try {
            fmt.formatterClass = defaultSimpleDateFormat;
            fmt.formatter = ReflectionUtil.construct(fmt.formatterClass, format);
        }
        catch (NoSuchMethodException e) {
            oops = true;
        }
        catch (IllegalAccessException e) {
            oops = true;
        }
        catch (InvocationTargetException e) {
            oops = true;
        }
        catch (NullPointerException e) {
            oops = true;
        }
        catch (InstantiationException e) {
            oops = true;
        }
        if (oops) {
            fmt.formatterClass = SimpleDateFormat.class;
            fmt.formatter = new SimpleDateFormat(format);
        }
        return fmt;
    }

    public void setLenient(boolean lenient) {
        block6: {
            try {
                Class[] lenientTypes = new Class[]{Boolean.TYPE};
                Object[] lenientParams = new Object[]{lenient};
                ReflectionUtil.invoke(this.formatterClass, this.formatter, "setLenient", lenientParams, lenientTypes);
            }
            catch (NoSuchMethodException e) {
                assert (false) : e;
            }
            catch (IllegalAccessException e) {
                assert (false) : e;
            }
            catch (InvocationTargetException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e);
            }
        }
    }

    public String format(Date date) {
        block6: {
            try {
                return (String)ReflectionUtil.invoke(this.formatterClass, this.formatter, "format", date);
            }
            catch (NoSuchMethodException e) {
                assert (false) : e;
            }
            catch (IllegalAccessException e) {
                assert (false) : e;
            }
            catch (InvocationTargetException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e);
            }
        }
        return "";
    }

    public Date parse(String text) {
        block6: {
            try {
                return (Date)ReflectionUtil.invoke(this.formatterClass, this.formatter, "parse", text);
            }
            catch (NoSuchMethodException e) {
                assert (false) : e;
            }
            catch (IllegalAccessException e) {
                assert (false) : e;
            }
            catch (InvocationTargetException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e);
            }
        }
        return new Date();
    }

    static {
        try {
            defaultSimpleDateFormat = ClassUtil.forName(DEFAULT_SIMPLE_DATE_FORMAT_CLASS);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.info("Error loading simple date format class [{}]", (Object)DEFAULT_SIMPLE_DATE_FORMAT_CLASS);
        }
        try {
            defaultDateFormat = ClassUtil.forName(DEFAULT_DATE_FORMAT_CLASS);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.info("Error loading date format class [{}]", (Object)DEFAULT_SIMPLE_DATE_FORMAT_CLASS);
        }
    }
}

