/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwordUtil {
    private static final Logger log = LoggerFactory.getLogger(SwordUtil.class);

    private SwordUtil() {
    }

    protected static byte[] readRAF(RandomAccessFile raf, long offset, int theSize) throws IOException {
        raf.seek(offset);
        return SwordUtil.readNextRAF(raf, theSize);
    }

    protected static byte[] readNextRAF(RandomAccessFile raf, int theSize) throws IOException {
        long offset = raf.getFilePointer();
        int size = theSize;
        long rafSize = raf.length();
        if (offset >= rafSize) {
            log.error("Attempt to read beyond end. offset={} size={} but raf.length={}", new Object[]{Long.toString(offset), Integer.toString(size), Long.toString(rafSize)});
            return new byte[0];
        }
        if (offset + (long)size > raf.length()) {
            log.error("Need to reduce size to avoid EOFException. offset={} size={} but raf.length={}", new Object[]{Long.toString(offset), Integer.toString(size), Long.toString(rafSize)});
            size = (int)(raf.length() - offset);
        }
        if (size < 1) {
            log.error("Nothing to read at offset = {} returning empty because size={}", (Object)Long.toString(offset), (Object)Integer.toString(size));
            return new byte[0];
        }
        byte[] read = new byte[size];
        raf.readFully(read);
        return read;
    }

    protected static void writeRAF(RandomAccessFile raf, long offset, byte[] data) throws IOException {
        raf.seek(offset);
        SwordUtil.writeNextRAF(raf, data);
    }

    protected static void writeNextRAF(RandomAccessFile raf, byte[] data) throws IOException {
        if (data == null) {
            return;
        }
        raf.write(data);
    }

    protected static byte[] readUntilRAF(RandomAccessFile raf, int offset, byte stopByte) throws IOException {
        raf.seek(offset);
        return SwordUtil.readUntilRAF(raf, stopByte);
    }

    protected static byte[] readUntilRAF(RandomAccessFile raf, byte stopByte) throws IOException {
        long offset = raf.getFilePointer();
        int size = 0;
        byte nextByte = -1;
        do {
            nextByte = raf.read();
            ++size;
        } while (nextByte != -1 && nextByte != stopByte);
        return SwordUtil.readRAF(raf, offset, size);
    }

    public static int decodeLittleEndian32(byte[] data, int offset) {
        int byte1 = data[0 + offset] & 0xFF;
        int byte2 = (data[1 + offset] & 0xFF) << 8;
        int byte3 = (data[2 + offset] & 0xFF) << 16;
        int byte4 = (data[3 + offset] & 0xFF) << 24;
        return byte4 | byte3 | byte2 | byte1;
    }

    protected static void encodeLittleEndian32(int val, byte[] data, int offset) {
        data[0 + offset] = (byte)(val & 0xFF);
        data[1 + offset] = (byte)(val >> 8 & 0xFF);
        data[2 + offset] = (byte)(val >> 16 & 0xFF);
        data[3 + offset] = (byte)(val >> 24 & 0xFF);
    }

    protected static int decodeLittleEndian16(byte[] data, int offset) {
        int byte1 = data[0 + offset] & 0xFF;
        int byte2 = (data[1 + offset] & 0xFF) << 8;
        return byte2 | byte1;
    }

    protected static void encodeLittleEndian16(int val, byte[] data, int offset) {
        data[0 + offset] = (byte)(val & 0xFF);
        data[1 + offset] = (byte)(val >> 8 & 0xFF);
    }

    protected static int findByte(byte[] data, byte sought) {
        return SwordUtil.findByte(data, 0, sought);
    }

    protected static int findByte(byte[] data, int offset, byte sought) {
        for (int i = offset; i < data.length; ++i) {
            if (data[i] != sought) continue;
            return i;
        }
        return -1;
    }

    public static String decode(String key, byte[] data, String charset) {
        return SwordUtil.decode(key, data, 0, data.length, charset);
    }

    public static String decode(String key, byte[] data, int length, String charset) {
        return SwordUtil.decode(key, data, 0, length, charset);
    }

    public static String decode(String key, byte[] data, int offset, int length, String charset) {
        if ("WINDOWS-1252".equals(charset)) {
            SwordUtil.clean1252(key, data, offset, length);
        }
        String txt = "";
        try {
            if (offset + length <= data.length) {
                txt = new String(data, offset, length, charset);
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.error("{}: Encoding {} not supported.", new Object[]{key, charset, ex});
            txt = new String(data, offset, length);
        }
        return txt;
    }

    private static void clean1252(String key, byte[] data, int offset, int length) {
        int end = offset + length;
        if (end > data.length) {
            end = data.length;
        }
        for (int i = offset; i < end; ++i) {
            int c = data[i] & 0xFF;
            if ((c < 0 || c >= 32 || c == 9 || c == 10 || c == 13) && c != 129 && c != 141 && c != 143 && c != 144 && c != 157) continue;
            data[i] = 32;
            log.error("{} has bad character 0x{} at position {} in input.", new Object[]{key, Integer.toString(c, 16), Integer.toString(i)});
        }
    }

    public static URI getExpandedDataPath(SwordBookMetaData bookMetaData) throws BookException {
        URI loc = NetUtil.lengthenURI(bookMetaData.getLibrary(), (String)bookMetaData.getProperty(ConfigEntryType.DATA_PATH));
        if (loc == null) {
            throw new BookException(JSOtherMsg.lookupText("Missing data files for old and new testaments in {0}.", new Object[0]));
        }
        return loc;
    }
}

