/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.IOUtil;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.AbstractKeyBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.jdom2.Content;
import org.jdom2.Element;

public class SwordDictionary
extends AbstractBook {
    private boolean active;
    private AbstractKeyBackend backend;
    private Filter filter;

    protected SwordDictionary(SwordBookMetaData sbmd, AbstractBackend backend) {
        super(sbmd);
        this.backend = (AbstractKeyBackend)backend;
        this.filter = sbmd.getFilter();
        this.active = false;
    }

    @Override
    public Iterator<Content> getOsisIterator(Key key, boolean allowEmpty) throws BookException {
        assert (key != null);
        assert (this.backend != null);
        ArrayList<Object> content = new ArrayList<Object>();
        Element title = OSISUtil.factory().createGeneratedTitle();
        title.addContent(key.getName());
        content.add(title);
        Closeable state = null;
        String txt = null;
        try {
            state = (Closeable)this.backend.initState();
            txt = this.backend.readRawContent(state, key);
        }
        catch (IOException e) {
            throw new BookException(e.getMessage(), e);
        }
        finally {
            IOUtil.close(state);
        }
        List<Content> osisContent = this.filter.toOSIS(this, key, txt);
        content.addAll(osisContent);
        return content.iterator();
    }

    @Override
    public String getRawText(Key key) throws BookException {
        Closeable state = null;
        try {
            state = (Closeable)this.backend.initState();
            String string = this.backend.readRawContent(state, key);
            return string;
        }
        catch (IOException e) {
            throw new BookException("Unable to obtain raw content from backend", e);
        }
        finally {
            IOUtil.close(state);
        }
    }

    @Override
    public boolean contains(Key key) {
        return this.backend != null && this.backend.contains(key);
    }

    @Override
    public List<Content> getOsis(Key key, RawTextToXmlProcessor processor) throws BookException {
        this.checkActive();
        assert (key != null);
        assert (this.backend != null);
        return this.backend.readToOsis(key, processor);
    }

    @Override
    public boolean isWritable() {
        return this.backend.isWritable();
    }

    @Override
    public void setRawText(Key key, String rawData) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public void setAliasKey(Key alias, Key source) throws BookException {
        throw new BookException(JSOtherMsg.lookupText("This Book is read-only.", new Object[0]));
    }

    @Override
    public Key getGlobalKeyList() {
        this.checkActive();
        return this.backend;
    }

    @Override
    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    @Override
    public Key getKey(String text) throws NoSuchKeyException {
        this.checkActive();
        int pos = this.backend.indexOf(new DefaultLeafKeyList(text));
        if (pos < 0) {
            if (this.backend.getCardinality() > -pos - 1) {
                return this.backend.get(-pos - 1);
            }
            return this.backend.get(this.backend.getCardinality() - 1);
        }
        return this.backend.get(pos);
    }

    @Override
    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }

    @Override
    public final void activate(Lock lock) {
        super.activate(lock);
        this.active = true;
    }

    @Override
    public final void deactivate(Lock lock) {
        super.deactivate(lock);
        this.active = false;
    }

    private void checkActive() {
        if (!this.active) {
            Activator.activate(this);
        }
    }
}

