/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.IOException;
import java.util.ArrayList;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.TreeKeyIndex;
import org.crosswire.jsword.book.sword.TreeNode;
import org.crosswire.jsword.book.sword.state.GenBookBackendState;
import org.crosswire.jsword.book.sword.state.OpenFileStateManager;
import org.crosswire.jsword.passage.AbstractKeyList;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.TreeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenBookBackend
extends AbstractBackend<GenBookBackendState> {
    private final TreeKeyIndex index;
    private static final Logger log = LoggerFactory.getLogger(GenBookBackend.class);

    public GenBookBackend(SwordBookMetaData sbmd) {
        super(sbmd);
        this.index = new TreeKeyIndex(sbmd);
    }

    @Override
    public GenBookBackendState initState() throws BookException {
        return OpenFileStateManager.getGenBookBackendState(this.getBookMetaData());
    }

    @Override
    public boolean contains(Key key) {
        try {
            return null != this.find(key);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String readRawContent(GenBookBackendState state, Key key) throws IOException, BookException {
        TreeNode node = this.find(key);
        if (node == null) {
            throw new BookException(JSMsg.gettext("No entry for '{0}' in {1}.", key.getName(), this.getBookMetaData().getInitials()));
        }
        byte[] userData = node.getUserData();
        if (userData.length == 8) {
            int start = SwordUtil.decodeLittleEndian32(userData, 0);
            int size = SwordUtil.decodeLittleEndian32(userData, 4);
            byte[] data = SwordUtil.readRAF(state.getBdtRaf(), start, size);
            this.decipher(data);
            return SwordUtil.decode(key.getName(), data, this.getBookMetaData().getBookCharset());
        }
        return "";
    }

    private TreeNode find(Key key) throws IOException {
        ArrayList<String> path = new ArrayList<String>();
        for (Key parentKey = key; parentKey != null && parentKey.getName().length() > 0; parentKey = parentKey.getParent()) {
            path.add(parentKey.getName());
        }
        TreeNode node = this.index.getRoot();
        node = this.index.getFirstChild(node);
        for (int i = path.size() - 1; i >= 0; --i) {
            String name = (String)path.get(i);
            while (node != null && !name.equals(node.getName())) {
                if (node.hasNextSibling()) {
                    node = this.index.getNextSibling(node);
                    continue;
                }
                log.error("Could not find {}", (Object)name);
                node = null;
            }
            if (node == null || !name.equals(node.getName()) || i <= 0) continue;
            node = this.index.getFirstChild(node);
        }
        if (node != null && node.getName().equals(key.getName())) {
            return node;
        }
        return null;
    }

    @Override
    public Key readIndex() {
        SwordBookMetaData bmd = this.getBookMetaData();
        AbstractKeyList reply = new DefaultKeyList(null, bmd.getName());
        try {
            TreeNode node = this.index.getRoot();
            reply = new TreeKey(node.getName(), null);
            this.doReadIndex(node, reply);
        }
        catch (IOException e) {
            log.error("Could not get read GenBook index", (Throwable)e);
        }
        return reply;
    }

    @Override
    public void setAliasKey(GenBookBackendState state, Key alias, Key source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawText(GenBookBackendState rafBook, Key key, String text) throws BookException, IOException {
        throw new UnsupportedOperationException();
    }

    private void doReadIndex(TreeNode parentNode, Key parentKey) throws IOException {
        TreeNode currentNode = parentNode;
        if (currentNode.hasChildren()) {
            TreeNode childNode = this.index.getFirstChild(currentNode);
            while (true) {
                TreeKey childKey = new TreeKey(childNode.getName(), parentKey);
                parentKey.addAll(childKey);
                this.doReadIndex(childNode, childKey);
                if (!childNode.hasNextSibling()) break;
                childNode = this.index.getNextSibling(childNode);
            }
        }
    }
}

